/*
 * Decompiled with CFR 0.152.
 */
package one.cafebabe.businesscalendar4j;

import java.net.URL;
import java.nio.file.Path;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import one.cafebabe.businesscalendar4j.BusinessCalendar;
import one.cafebabe.businesscalendar4j.BusinessCalendarPredicate;
import one.cafebabe.businesscalendar4j.BusinessHourFromTo;
import one.cafebabe.businesscalendar4j.BusinessHourSlot;
import one.cafebabe.businesscalendar4j.CsvConfiguration;
import one.cafebabe.businesscalendar4j.HolidayMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BusinessCalendarBuilder {
    private boolean built = false;
    final List<Function<LocalDate, String>> holidayLogics = new ArrayList<Function<LocalDate, String>>();
    private final HolidayMap customHolidayMap = new HolidayMap();
    Locale locale = Locale.getDefault();
    final List<Function<LocalDate, List<BusinessHourSlot>>> businessHours = new ArrayList<Function<LocalDate, List<BusinessHourSlot>>>();

    public BusinessCalendarBuilder locale(Locale locale) {
        this.ensureNotBuilt();
        this.holidayLogics.add(this.customHolidayMap);
        this.locale = locale;
        return this;
    }

    Function<LocalDate, String> holiday() {
        return date -> this.holidayLogics.stream().map(e -> (String)e.apply(date)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @SafeVarargs
    public final BusinessCalendarBuilder holiday(Function<LocalDate, String> ... logics) {
        this.ensureNotBuilt();
        Collections.addAll(this.holidayLogics, logics);
        return this;
    }

    @NotNull
    public BusinessCalendar build() {
        this.ensureNotBuilt();
        this.built = true;
        return new BusinessCalendar(this);
    }

    @NotNull
    public BusinessCalendarBuilder hours(String businessHour) {
        this.businessHours.add(new BusinessHours(e -> true, businessHour));
        return this;
    }

    @NotNull
    public BusinessCalendarPredicate on(DayOfWeek ... dayOfWeek) {
        this.ensureNotBuilt();
        return new BusinessCalendarPredicate(this, dayOfWeek);
    }

    @NotNull
    public BusinessCalendarPredicate on(int ordinal, DayOfWeek ... dayOfWeek) {
        this.ensureNotBuilt();
        return new BusinessCalendarPredicate(this, ordinal, dayOfWeek);
    }

    @NotNull
    public BusinessCalendarPredicate on(int year, int month, int day) {
        this.ensureNotBuilt();
        return new BusinessCalendarPredicate(e -> e.getYear() == year && e.getMonthValue() == month && e.getDayOfMonth() == day, this);
    }

    @NotNull
    public BusinessCalendarPredicate on(LocalDate date) {
        this.ensureNotBuilt();
        return new BusinessCalendarPredicate(date, this);
    }

    @NotNull
    public BusinessCalendarPredicate on(int month, int day) {
        this.ensureNotBuilt();
        return new BusinessCalendarPredicate(e -> e.getMonthValue() == month && e.getDayOfMonth() == day, this);
    }

    @NotNull
    public BusinessCalendarPredicate on(@NotNull Predicate<LocalDate> predicate) {
        this.ensureNotBuilt();
        return new BusinessCalendarPredicate(predicate, this);
    }

    @NotNull
    Function<LocalDate, List<BusinessHourSlot>> getBusinessHours() {
        return date -> {
            for (Function<LocalDate, List<BusinessHourSlot>> bh : this.businessHours) {
                List<BusinessHourSlot> apply = bh.apply((LocalDate)date);
                if (apply == null) continue;
                return apply;
            }
            return null;
        };
    }

    private void ensureNotBuilt() {
        if (this.built) {
            throw new IllegalStateException("Already built");
        }
    }

    public BusinessCalendarBuilder csv(Path path) {
        this.csv(path, null);
        return this;
    }

    public BusinessCalendarBuilder csv(@NotNull Path path, @Nullable Duration reloadInterval) {
        CsvConfiguration csv = CsvConfiguration.getInstance(path);
        csv.scheduleReload(reloadInterval);
        this.holidayLogics.add(csv.holiday());
        this.businessHours.add(csv.getBusinessHours());
        return this;
    }

    public BusinessCalendarBuilder csv(URL url) {
        this.csv(url, null);
        return this;
    }

    public BusinessCalendarBuilder csv(URL url, @Nullable Duration reloadInterval) {
        CsvConfiguration csv = CsvConfiguration.getInstance(url);
        this.holidayLogics.add(csv.holiday());
        this.businessHours.add(csv.getBusinessHours());
        csv.scheduleReload(reloadInterval);
        return this;
    }

    public BusinessCalendarBuilder csv(CsvConfiguration csv) {
        this.csv(csv, null);
        return this;
    }

    public BusinessCalendarBuilder csv(CsvConfiguration csv, @Nullable Duration reloadInterval) {
        this.holidayLogics.add(csv.holiday());
        this.businessHours.add(csv.getBusinessHours());
        csv.scheduleReload(reloadInterval);
        return this;
    }

    static class BusinessHours
    implements Function<LocalDate, List<BusinessHourSlot>> {
        private final Predicate<LocalDate> predicate;
        private final List<BusinessHourFromTo> businessHourFromTos = new ArrayList<BusinessHourFromTo>();

        public BusinessHours(Predicate<LocalDate> predicate, String businessHour) {
            String[] slots;
            this.predicate = predicate;
            for (String slot : slots = businessHour.replaceAll(" ", "").replaceAll("[\u3001&]", ",").split(",")) {
                LocalTime to;
                String[] split = slot.replaceAll("(to|\u304b\u3089|\u301c|~)", "-").split("-");
                LocalTime from = this.toLocalTime(split[0]);
                this.checkParameter(from.isBefore(to = this.toLocalTime(split[1])) || to.equals(LocalTime.of(0, 0)), "from should be before to, provided: " + slot);
                this.businessHourFromTos.add(new BusinessHourFromTo(from, to));
            }
            this.businessHourFromTos.sort(Comparator.comparing(e -> e.from));
        }

        @Override
        public List<BusinessHourSlot> apply(LocalDate localDate) {
            if (this.predicate.test(localDate)) {
                return this.businessHourFromTos.stream().map(e -> new BusinessHourSlot(localDate, e.from, e.to)).collect(Collectors.toList());
            }
            return null;
        }

        private LocalTime toLocalTime(String timeStr) {
            int hour;
            String ampm = timeStr.replaceAll("[0-9.:\u6642\u534a]", "").toLowerCase();
            boolean half = timeStr.contains("\u534a");
            timeStr = timeStr.replaceAll("[^0-9:]", "");
            String[] split = timeStr.split(":");
            int n = hour = ampm.matches("(noon|\u6b63\u5348)") ? 12 : Integer.parseInt(split[0]);
            if (ampm.matches("(a|am|\u5348\u524d)") && hour == 12) {
                hour = 0;
            }
            if (ampm.matches("(p|pm|\u5348\u5f8c)") && hour != 12) {
                hour += 12;
            }
            if (ampm.matches("midnight")) {
                hour = 24;
            }
            int minutes = 0;
            if (2 <= split.length) {
                minutes = Integer.parseInt(split[1]);
            }
            if (half) {
                minutes = 30;
            }
            int seconds = 0;
            if (3 <= split.length) {
                seconds = Integer.parseInt(split[2]);
            }
            if (hour == 24 && minutes == 0 && seconds == 0) {
                return LocalTime.of(0, 0);
            }
            this.checkParameter(0 <= hour, "hour should be greater than or equals to 0, provided: " + timeStr);
            this.checkParameter(hour <= 24, "hour should be less than or equals to 24, provided: " + timeStr);
            this.checkParameter(0 <= minutes, "minutes should be greater than or equals to 0, provided: " + timeStr);
            this.checkParameter(minutes <= 59, "minutes should be less than 60, provided: " + timeStr);
            this.checkParameter(0 <= seconds, "seconds should be greater than or equals to 0, provided: " + timeStr);
            this.checkParameter(seconds <= 59, "seconds should be less than 60, provided: " + timeStr);
            return LocalTime.of(hour, minutes, seconds);
        }

        void checkParameter(boolean expectedToBeTrue, @NotNull String message) {
            if (!expectedToBeTrue) {
                throw new IllegalArgumentException(message);
            }
        }
    }
}

