/*
 * Decompiled with CFR 0.152.
 */
package one.cafebabe.businesscalendar4j;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class BusinessHourSlot
implements Serializable {
    private static final long serialVersionUID = -102401732734407839L;
    @NotNull
    public final LocalDateTime from;
    @NotNull
    public final LocalDateTime to;

    BusinessHourSlot(@NotNull LocalDate baseDate, @NotNull LocalTime from, @NotNull LocalTime to) {
        this.from = LocalDateTime.of(baseDate, from);
        this.to = to.getHour() == 0 && to.getMinute() == 0 ? LocalDateTime.of(baseDate.plus(1L, ChronoUnit.DAYS), to) : LocalDateTime.of(baseDate, to);
    }

    boolean isBusinessHour(@NotNull LocalDateTime time) {
        return time.isEqual(this.from) || this.from.isBefore(time) && this.to.isAfter(time);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessHourSlot that = (BusinessHourSlot)o;
        return this.from.equals(that.from) && this.to.equals(that.to);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }

    public String toString() {
        return "BusinessHourSlot{from=" + this.from + ", to=" + this.to + '}';
    }
}

