/*
 * Decompiled with CFR 0.152.
 */
package one.cafebabe.businesscalendar4j;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import one.cafebabe.businesscalendar4j.BusinessCalendarPredicate;

public class UnitedStates {
    public final Function<LocalDate, String> NEW_YEARS_DAY = UnitedStates.substitution(BusinessCalendarPredicate.predicate(1, 1), "unitedStates.NewYearsDay");
    public final Function<LocalDate, String> MARTIN_LUTHER_KING_JR_DAY = BusinessCalendarPredicate.holiday(BusinessCalendarPredicate.predicate(3, DayOfWeek.MONDAY, 1), "unitedStates.MartinLutherKingJrDay");
    public final Function<LocalDate, String> MEMORIAL_DAY = BusinessCalendarPredicate.holiday(date -> date.getMonthValue() == 5 && date.getDayOfMonth() == date.with(TemporalAdjusters.lastInMonth(DayOfWeek.MONDAY)).getDayOfMonth(), "unitedStates.MemorialDay");
    public final Function<LocalDate, String> INDEPENDENCE_DAY = UnitedStates.substitution(BusinessCalendarPredicate.predicate(7, 4), "unitedStates.IndependenceDay");
    public final Function<LocalDate, String> LABOR_DAY = BusinessCalendarPredicate.holiday(BusinessCalendarPredicate.predicate(1, DayOfWeek.MONDAY, 9), "unitedStates.LaborDay");
    public final Function<LocalDate, String> VETERANS_DAY = UnitedStates.substitution(BusinessCalendarPredicate.predicate(11, 11), "unitedStates.VeteransDay");
    public final Function<LocalDate, String> THANKSGIVING_DAY = BusinessCalendarPredicate.holiday(BusinessCalendarPredicate.predicate(4, DayOfWeek.THURSDAY, 11), "unitedStates.ThanksgivingDay");
    public final Function<LocalDate, String> CHRISTMAS_DAY = UnitedStates.substitution(BusinessCalendarPredicate.predicate(12, 25), "unitedStates.ChristmasDay");
    private static final UnitedStates singleton = new UnitedStates();
    private final List<Function<LocalDate, String>> all = Arrays.asList(this.NEW_YEARS_DAY, this.MARTIN_LUTHER_KING_JR_DAY, this.MEMORIAL_DAY, this.INDEPENDENCE_DAY, this.LABOR_DAY, this.VETERANS_DAY, this.THANKSGIVING_DAY, this.CHRISTMAS_DAY);
    public Function<LocalDate, String> PUBLIC_HOLIDAYS = localDate -> {
        for (Function<LocalDate, String> localDateStringFunction : this.all) {
            String apply = localDateStringFunction.apply((LocalDate)localDate);
            if (apply == null) continue;
            return apply;
        }
        return null;
    };

    private static Function<LocalDate, String> substitution(Predicate<LocalDate> predicate, String name) {
        return date -> {
            if (predicate.test((LocalDate)date)) {
                return name;
            }
            LocalDate movedFrom = null;
            if (date.getDayOfWeek() == DayOfWeek.MONDAY) {
                movedFrom = date.minus(1L, ChronoUnit.DAYS);
            } else if (date.getDayOfWeek() == DayOfWeek.FRIDAY) {
                movedFrom = date.plus(1L, ChronoUnit.DAYS);
            }
            if (movedFrom != null && predicate.test(movedFrom)) {
                return "${" + name + "} (${unitedStates.observed})";
            }
            return null;
        };
    }

    private UnitedStates() {
    }

    static UnitedStates getInstance() {
        return singleton;
    }
}

