/*
 * Decompiled with CFR 0.152.
 */
package one.cafebabe.businesscalendar4j;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.function.Function;
import java.util.function.Predicate;
import one.cafebabe.businesscalendar4j.BusinessCalendarBuilder;
import org.jetbrains.annotations.NotNull;

public class BusinessCalendarPredicate {
    private final BusinessCalendarBuilder builder;
    private final Predicate<LocalDate> predicate;

    BusinessCalendarPredicate(@NotNull BusinessCalendarBuilder builder, int ordinal, DayOfWeek ... dayOfWeeks) {
        this.predicate = BusinessCalendarPredicate.predicate(ordinal, dayOfWeeks);
        this.builder = builder;
    }

    BusinessCalendarPredicate(@NotNull BusinessCalendarBuilder builder, DayOfWeek ... dayOfWeeks) {
        this.predicate = e -> {
            for (DayOfWeek dayOfWeek : dayOfWeeks) {
                if (dayOfWeek != e.getDayOfWeek()) continue;
                return true;
            }
            return false;
        };
        this.builder = builder;
    }

    BusinessCalendarPredicate(@NotNull Predicate<LocalDate> predicate, @NotNull BusinessCalendarBuilder builder) {
        this.predicate = predicate;
        this.builder = builder;
    }

    BusinessCalendarPredicate(@NotNull LocalDate date, @NotNull BusinessCalendarBuilder builder) {
        this.predicate = e -> e.isEqual(date);
        this.builder = builder;
    }

    @NotNull
    public BusinessCalendarBuilder hours(@NotNull String businessHour) {
        this.builder.businessHours.add(new BusinessCalendarBuilder.BusinessHours(this.predicate, businessHour));
        return this.builder;
    }

    @NotNull
    public BusinessCalendarBuilder holiday(@NotNull String name) {
        return this.builder.holiday(BusinessCalendarPredicate.holiday(this.predicate, name));
    }

    @NotNull
    static Function<LocalDate, String> holiday(@NotNull Predicate<LocalDate> predicate, @NotNull String name) {
        return date -> predicate.test((LocalDate)date) ? name : null;
    }

    @NotNull
    static Predicate<LocalDate> predicate(int month, int day) {
        return e -> e.getMonthValue() == month && e.getDayOfMonth() == day;
    }

    @NotNull
    static Predicate<LocalDate> predicate(int ordinal, @NotNull DayOfWeek dayOfWeek, int month) {
        return e -> e.getMonthValue() == month && BusinessCalendarPredicate.dayOfWeekOrdinalMatches(e, ordinal, dayOfWeek);
    }

    @NotNull
    static Predicate<LocalDate> predicate(int ordinal, @NotNull DayOfWeek[] dayOfWeeks) {
        return e -> {
            for (DayOfWeek dayOfWeek : dayOfWeeks) {
                if (dayOfWeek != e.getDayOfWeek() || !BusinessCalendarPredicate.dayOfWeekOrdinalMatches(e, ordinal, dayOfWeek)) continue;
                return true;
            }
            return false;
        };
    }

    static boolean dayOfWeekOrdinalMatches(LocalDate e, int ordinal, DayOfWeek dayOfWeek) {
        int day = e.with(TemporalAdjusters.dayOfWeekInMonth(ordinal, dayOfWeek)).getDayOfMonth();
        return e.getDayOfMonth() == day;
    }
}

