/*
 * Decompiled with CFR 0.152.
 */
package one.cafebabe.businesscalendar4j;

import java.nio.charset.Charset;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.Random;
import java.util.function.Function;
import one.cafebabe.businesscalendar4j.BusinessCalendarPredicate;
import one.cafebabe.businesscalendar4j.CSVHolidays;

public final class Japan {
    public final Function<LocalDate, String> CLOSED_ON_NEW_YEARS_HOLIDAYS = e -> e.getMonthValue() == 1 && e.getDayOfMonth() <= 3 ? "\u4e09\u304c\u65e5" : null;
    public final Function<LocalDate, String> CLOSED_ON_NEW_YEARS_EVE = e -> e.getMonthValue() == 12 && e.getDayOfMonth() == 31 ? "\u5927\u6666\u65e5" : null;
    private static final long aboutOneMonth = 2678400000L + new Random(System.currentTimeMillis()).nextLong() % 36000000L;
    static final CSVHolidays csv = new CSVHolidays(aboutOneMonth, System.getProperty("SYUKUJITSU_URL", "https://www8.cao.go.jp/chosei/shukujitsu/syukujitsu.csv"), "/syukujitsu.csv", "japanese.", Charset.forName("Shift_JIS"));
    private static final Japan singleton = new Japan();
    public Function<LocalDate, String> PUBLIC_HOLIDAYS = new Function<LocalDate, String>(){

        @Override
        public String apply(LocalDate e) {
            String apply = csv.apply(e);
            if (apply != null) {
                return apply;
            }
            int year = e.getYear();
            int month = e.getMonthValue();
            int day = e.getDayOfMonth();
            if (month == 1 && day == 1) {
                return "japanese.\u5143\u65e5";
            }
            if (((LocalDate)Japan.csv.holidayMap.lastKey()).isAfter(e)) {
                return null;
            }
            switch (month) {
                case 6: 
                case 12: {
                    break;
                }
                case 1: {
                    if (!BusinessCalendarPredicate.dayOfWeekOrdinalMatches(e, 2, DayOfWeek.MONDAY)) break;
                    return "japanese.\u6210\u4eba\u306e\u65e5";
                }
                case 2: {
                    if (day == 11) {
                        return "japanese.\u5efa\u56fd\u8a18\u5ff5\u306e\u65e5";
                    }
                    if (day != 23) break;
                    return "japanese.\u5929\u7687\u8a95\u751f\u65e5";
                }
                case 3: {
                    int[] \u4e8c\u5341\u4e00\u65e5\u304c\u6625\u5206\u306e\u65e5\u306e\u5e74 = new int[]{2002, 2003, 2006, 2007, 2010, 2011, 2014, 2015, 2018, 2019, 2022, 2023, 2027};
                    switch (day) {
                        case 20: {
                            for (int \u4e8c\u5341\u4e00\u65e5year : \u4e8c\u5341\u4e00\u65e5\u304c\u6625\u5206\u306e\u65e5\u306e\u5e74) {
                                if (year != \u4e8c\u5341\u4e00\u65e5year) continue;
                                return null;
                            }
                            return "japanese.\u6625\u5206\u306e\u65e5";
                        }
                        case 21: {
                            for (int \u4e8c\u5341\u4e00\u65e5year : \u4e8c\u5341\u4e00\u65e5\u304c\u6625\u5206\u306e\u65e5\u306e\u5e74) {
                                if (year != \u4e8c\u5341\u4e00\u65e5year) continue;
                                return "japanese.\u6625\u5206\u306e\u65e5";
                            }
                            break;
                        }
                    }
                    break;
                }
                case 4: {
                    if (day != 29) break;
                    return "japanese.\u662d\u548c\u306e\u65e5";
                }
                case 5: {
                    if (day == 3) {
                        return "japanese.\u61b2\u6cd5\u8a18\u5ff5\u65e5";
                    }
                    if (day == 4) {
                        return "japanese.\u307f\u3069\u308a\u306e\u65e5";
                    }
                    if (day != 5) break;
                    return "japanese.\u3053\u3069\u3082\u306e\u65e5";
                }
                case 7: {
                    if (!BusinessCalendarPredicate.dayOfWeekOrdinalMatches(e, 3, DayOfWeek.MONDAY)) break;
                    return "japanese.\u6d77\u306e\u65e5";
                }
                case 8: {
                    if (day != 11) break;
                    return "japanese.\u5c71\u306e\u65e5";
                }
                case 9: {
                    int[] \u4e8c\u5341\u4e8c\u65e5\u304c\u79cb\u5206\u306e\u65e5\u306e\u5e74 = new int[]{2012, 2016, 2020, 2024, 2028};
                    int \u656c\u8001\u306e\u65e5 = e.with(TemporalAdjusters.dayOfWeekInMonth(3, DayOfWeek.MONDAY)).getDayOfMonth();
                    if (day == \u656c\u8001\u306e\u65e5) {
                        return "japanese.\u656c\u8001\u306e\u65e5";
                    }
                    int \u79cb\u5206\u306e\u65e5 = 23;
                    for (int \u4e8c\u5341\u4e8c\u65e5year : \u4e8c\u5341\u4e8c\u65e5\u304c\u79cb\u5206\u306e\u65e5\u306e\u5e74) {
                        if (year != \u4e8c\u5341\u4e8c\u65e5year) continue;
                        \u79cb\u5206\u306e\u65e5 = 22;
                        break;
                    }
                    if (day - 1 == \u656c\u8001\u306e\u65e5 && day + 1 == \u79cb\u5206\u306e\u65e5) {
                        return "japanese.\u4f11\u65e5";
                    }
                    if (day != \u79cb\u5206\u306e\u65e5) break;
                    return "japanese.\u79cb\u5206\u306e\u65e5";
                }
                case 10: {
                    if (!BusinessCalendarPredicate.dayOfWeekOrdinalMatches(e, 2, DayOfWeek.MONDAY)) break;
                    return "japanese.\u30b9\u30dd\u30fc\u30c4\u306e\u65e5";
                }
                case 11: {
                    if (day == 3) {
                        return "japanese.\u6587\u5316\u306e\u65e5";
                    }
                    if (day != 23) break;
                    return "japanese.\u52e4\u52b4\u611f\u8b1d\u306e\u65e5";
                }
            }
            LocalDate test = e.minus(1L, ChronoUnit.DAYS);
            while (test.getDayOfWeek() != DayOfWeek.SATURDAY) {
                String \u5c0e\u51fa\u795d\u4f11\u65e5 = this.apply(test);
                if (!Japan.csv.holidayMap.containsKey(test) && \u5c0e\u51fa\u795d\u4f11\u65e5 == null || "japanese.\u4f11\u65e5".equals(\u5c0e\u51fa\u795d\u4f11\u65e5)) break;
                if (test.getDayOfWeek() == DayOfWeek.SUNDAY) {
                    return "japanese.\u4f11\u65e5";
                }
                test = test.minus(1L, ChronoUnit.DAYS);
            }
            return null;
        }
    };

    static Japan getInstance() {
        return singleton;
    }

    public static LocalDate getCabinetOfficialHolidayDataFirstDay() {
        return (LocalDate)Japan.csv.holidayMap.firstKey();
    }

    public static LocalDate getCabinetOfficialHolidayDataLastDay() {
        return (LocalDate)Japan.csv.holidayMap.lastKey();
    }
}

