/*
 * Decompiled with CFR 0.152.
 */
package one.cafebabe.businesscalendar4j;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.cafebabe.businesscalendar4j.BusinessCalendarBuilder;
import one.cafebabe.businesscalendar4j.BusinessHourSlot;
import one.cafebabe.businesscalendar4j.Holiday;
import one.cafebabe.businesscalendar4j.Japan;
import one.cafebabe.businesscalendar4j.UnitedStates;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BusinessCalendar {
    public static final UnitedStates UNITED_STATES = UnitedStates.getInstance();
    public static final Japan JAPAN = Japan.getInstance();
    private final List<Function<LocalDate, String>> holidayLogics = new ArrayList<Function<LocalDate, String>>();
    private final List<Function<LocalDate, List<BusinessHourSlot>>> businessHours = new ArrayList<Function<LocalDate, List<BusinessHourSlot>>>();
    private final ResourceBundle resource;
    public static final Function<LocalDate, String> CLOSED_ON_SATURDAYS_AND_SUNDAYS = localDate -> switch (localDate.getDayOfWeek()) {
        case DayOfWeek.SATURDAY -> "japanese.\u571f\u66dc\u65e5";
        case DayOfWeek.SUNDAY -> "japanese.\u65e5\u66dc\u65e5";
        default -> null;
    };
    private final BusinessCalendarBuilder.BusinessHours OPEN24HOURS = new BusinessCalendarBuilder.BusinessHours(e -> true, "0-24");
    private static final Pattern p = Pattern.compile("\\$\\{([a-z.A-Z]+)}");
    private static final DateTimeFormatter HHmm = DateTimeFormatter.ofPattern("HH:mm");
    private static final DateTimeFormatter HHmmss = DateTimeFormatter.ofPattern("HH:mm:ss");

    BusinessCalendar(BusinessCalendarBuilder conf) {
        this.resource = ResourceBundle.getBundle("holidays", conf.locale);
        this.holidayLogics.add(conf.holiday());
        this.businessHours.add(conf.getBusinessHours());
    }

    @NotNull
    public static BusinessCalendarBuilder newBuilder() {
        return new BusinessCalendarBuilder();
    }

    public boolean isHoliday(@NotNull LocalDate date) {
        return this.holidayLogics.stream().anyMatch(e -> e.apply(date) != null);
    }

    public boolean isHoliday() {
        LocalDate today = LocalDate.now();
        return this.holidayLogics.stream().anyMatch(e -> e.apply(today) != null);
    }

    public boolean isBusinessDay(@NotNull LocalDate date) {
        return !this.isHoliday(date);
    }

    public boolean isBusinessDay() {
        return !this.isHoliday(LocalDate.now());
    }

    public boolean isBusinessHour(@NotNull LocalDateTime dateTime) {
        return this.isBusinessDay(dateTime.toLocalDate()) && this.getBusinessHourSlots(dateTime.toLocalDate()).stream().anyMatch(e -> e.isBusinessHour(dateTime));
    }

    public boolean isBusinessHour() {
        return this.isBusinessHour(LocalDateTime.now());
    }

    @NotNull
    public List<BusinessHourSlot> getBusinessHourSlots(@NotNull LocalDate date) {
        if (this.isHoliday(date)) {
            return Collections.emptyList();
        }
        return this.businessHours.stream().map(e -> (List)e.apply(date)).filter(Objects::nonNull).findFirst().orElseGet(() -> this.OPEN24HOURS.apply(date));
    }

    @NotNull
    public LocalDateTime lastBusinessHourEnd(@NotNull LocalDateTime when) {
        List<BusinessHourSlot> slots;
        List<BusinessHourSlot> list;
        LocalDate date = when.toLocalDate();
        LocalDateTime lastBusinessHourEnd = null;
        if (this.isBusinessDay(date) && !(list = (slots = this.getBusinessHourSlots(date)).stream().filter(e -> e.to().isBefore(when) || e.to().isEqual(when)).toList()).isEmpty()) {
            lastBusinessHourEnd = list.get(list.size() - 1).to();
        }
        if (lastBusinessHourEnd == null) {
            slots = this.getBusinessHourSlots(this.lastBusinessDay(date.minusDays(1L)));
            lastBusinessHourEnd = slots.get(slots.size() - 1).to();
        }
        return lastBusinessHourEnd;
    }

    @NotNull
    public LocalDateTime nextBusinessHourEnd(@NotNull LocalDateTime when) {
        List<BusinessHourSlot> slots;
        List<BusinessHourSlot> list;
        LocalDate date = when.toLocalDate();
        LocalDateTime nextBusinessHourEnd = null;
        if (this.isBusinessDay(date) && !(list = (slots = this.getBusinessHourSlots(date)).stream().filter(e -> e.to().isAfter(when) || e.to().isEqual(when)).toList()).isEmpty()) {
            nextBusinessHourEnd = list.get(0).to();
        }
        if (nextBusinessHourEnd == null) {
            slots = this.getBusinessHourSlots(this.firstBusinessDay(date.plusDays(1L)));
            nextBusinessHourEnd = slots.get(0).to();
        }
        return nextBusinessHourEnd;
    }

    @NotNull
    public LocalDateTime lastBusinessHourStart(@NotNull LocalDateTime when) {
        List<BusinessHourSlot> slots;
        List<BusinessHourSlot> list;
        LocalDate date = when.toLocalDate();
        LocalDateTime lastBusinessHourStart = null;
        if (this.isBusinessDay(date) && !(list = (slots = this.getBusinessHourSlots(date)).stream().filter(e -> e.from().isBefore(when)).toList()).isEmpty()) {
            lastBusinessHourStart = list.get(list.size() - 1).from();
        }
        if (lastBusinessHourStart == null) {
            slots = this.getBusinessHourSlots(this.lastBusinessDay(date.minusDays(1L)));
            lastBusinessHourStart = slots.get(slots.size() - 1).from();
        }
        return lastBusinessHourStart;
    }

    @NotNull
    public LocalDateTime nextBusinessHourStart(@NotNull LocalDateTime when) {
        List<BusinessHourSlot> slots;
        List<BusinessHourSlot> list;
        LocalDate date = when.toLocalDate();
        LocalDateTime nextBusinessHourStart = null;
        if (this.isBusinessDay(date) && !(list = (slots = this.getBusinessHourSlots(date)).stream().filter(e -> e.from().isAfter(when) || e.from().isEqual(when)).toList()).isEmpty()) {
            nextBusinessHourStart = list.get(0).from();
        }
        if (nextBusinessHourStart == null) {
            slots = this.getBusinessHourSlots(this.firstBusinessDay(date.plusDays(1L)));
            nextBusinessHourStart = slots.get(0).from();
        }
        return nextBusinessHourStart;
    }

    @Nullable
    public Holiday getHoliday(@NotNull LocalDate date) {
        Optional<String> first = this.holidayLogics.stream().map(e -> (String)e.apply(date)).filter(Objects::nonNull).findFirst();
        return first.map(s -> new Holiday(date, this.toHolidayString((String)s))).orElse(null);
    }

    @NotNull
    private String toHolidayString(@NotNull String key) {
        if (this.resource.containsKey(key)) {
            return this.resource.getString(key);
        }
        Matcher matcher = p.matcher(key);
        StringBuilder b = new StringBuilder();
        int start = 0;
        while (matcher.find()) {
            b.append(key, start, matcher.start());
            String group = matcher.group(1);
            b.append(this.resource.getString(group));
            start = matcher.end();
        }
        b.append(key, start, key.length());
        return b.toString();
    }

    @NotNull
    public LocalDate lastBusinessDay(@NotNull LocalDate date) {
        LocalDate check = date;
        while (this.isHoliday(check)) {
            check = check.minusDays(1L);
        }
        return check;
    }

    @NotNull
    public LocalDate lastBusinessDay() {
        return this.lastBusinessDay(LocalDate.now());
    }

    @NotNull
    public LocalDate firstBusinessDay(@NotNull LocalDate date) {
        LocalDate check = date;
        while (this.isHoliday(check)) {
            check = check.plusDays(1L);
        }
        return check;
    }

    @NotNull
    public LocalDate firstBusinessDay() {
        return this.firstBusinessDay(LocalDate.now());
    }

    @NotNull
    public Holiday lastHoliday(@NotNull LocalDate date) {
        LocalDate check = date;
        while (!this.isHoliday(check)) {
            if (check.equals(LocalDate.MIN)) {
                return new Holiday(LocalDate.MIN, "min");
            }
            check = check.minusDays(1L);
        }
        return Objects.requireNonNull(this.getHoliday(check));
    }

    @NotNull
    public Holiday lastHoliday() {
        return this.lastHoliday(LocalDate.now());
    }

    @NotNull
    public Holiday firstHoliday(@NotNull LocalDate date) {
        LocalDate check = date;
        while (!this.isHoliday(check)) {
            if (check.equals(LocalDate.MAX)) {
                return new Holiday(LocalDate.MAX, "max");
            }
            check = check.plusDays(1L);
        }
        return Objects.requireNonNull(this.getHoliday(check));
    }

    @NotNull
    public Holiday firstHoliday() {
        return this.firstHoliday(LocalDate.now());
    }

    @NotNull
    public List<Holiday> getHolidaysBetween(@NotNull LocalDate from, @NotNull LocalDate to) {
        ArrayList<Holiday> list = new ArrayList<Holiday>();
        LocalDate start = from.isBefore(to) ? from : to;
        LocalDate end = (to.isAfter(from) ? to : from).plusDays(1L);
        while (start.isBefore(end)) {
            Holiday holiday = this.getHoliday(start);
            if (holiday != null) {
                list.add(holiday);
            }
            start = start.plusDays(1L);
        }
        return list;
    }

    @NotNull
    public List<LocalDate> getBusinessDaysBetween(@NotNull LocalDate from, @NotNull LocalDate to) {
        ArrayList<LocalDate> list = new ArrayList<LocalDate>();
        LocalDate start = from.isBefore(to) ? from : to;
        LocalDate end = (to.isAfter(from) ? to : from).plusDays(1L);
        while (start.isBefore(end)) {
            if (this.isBusinessDay(start)) {
                list.add(start);
            }
            start = start.plusDays(1L);
        }
        return list;
    }

    public String dump(@NotNull LocalDate from, @NotNull LocalDate to) {
        return this.dump(from, to, "yyyy/MM/dd");
    }

    public String dump(@NotNull LocalDate from, @NotNull LocalDate to, String dateFormat) {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(dateFormat);
        StringBuilder buf = new StringBuilder();
        LocalDate start = from.isBefore(to) ? from : to;
        LocalDate end = (to.isAfter(from) ? to : from).plusDays(1L);
        while (start.isBefore(end)) {
            if (this.isBusinessDay(start)) {
                buf.append(start.format(dateFormatter)).append(" : ");
                boolean first = true;
                for (BusinessHourSlot slot : this.getBusinessHourSlots(start)) {
                    if (!first) {
                        buf.append(", ");
                    }
                    first = false;
                    buf.append(this.formatTime(slot.from())).append("-").append(this.formatTime(slot.to()));
                }
            } else {
                buf.append("%s : %s".formatted(start.format(dateFormatter), Objects.requireNonNull(this.getHoliday(start)).name()));
            }
            buf.append("\n");
            start = start.plusDays(1L);
        }
        return buf.toString();
    }

    private String formatTime(LocalDateTime time) {
        if (time.getSecond() == 0) {
            return time.format(HHmm);
        }
        return time.format(HHmmss);
    }
}

