/*
 * Decompiled with CFR 0.152.
 */
package one.cafebabe.businesscalendar4j;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.MonthDay;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import one.cafebabe.businesscalendar4j.BusinessCalendarBuilder;
import one.cafebabe.businesscalendar4j.BusinessCalendarPredicate;
import one.cafebabe.businesscalendar4j.BusinessHourSlot;
import one.cafebabe.businesscalendar4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CsvConfiguration {
    private final Logger logger = Logger.getLogger();
    private BusinessCalendarBuilder builder;
    @Nullable
    private final Path path;
    @Nullable
    private final URL url;
    private long lastModified = -1L;
    private boolean reloadScheduled = false;
    private static final Map<String, String> convert = new HashMap<String, String>(){
        {
            this.put("MON", "MONDAY");
            this.put("TUE", "TUESDAY");
            this.put("WED", "WEDNESDAY");
            this.put("THU", "THURSDAY");
            this.put("FRI", "FRIDAY");
            this.put("SAT", "SATURDAY");
            this.put("SUN", "SUNDAY");
        }
    };

    public static CsvConfiguration getInstance(@NotNull Path path) {
        return new CsvConfiguration(path);
    }

    public static CsvConfiguration getInstance(@NotNull URL url) {
        return new CsvConfiguration(url);
    }

    private CsvConfiguration(@NotNull Path path) {
        this.path = path;
        this.url = null;
        this.reload();
    }

    private CsvConfiguration(@NotNull URL url) {
        this.path = null;
        this.url = url;
        this.reload();
    }

    void scheduleReload(@Nullable Duration interval) {
        if (this.reloadScheduled) {
            throw new IllegalStateException("reload already scheduled");
        }
        if (interval != null) {
            this.reloadScheduled = true;
            Thread thread = new Thread(() -> {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(interval.toMillis());
                            this.reload();
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            });
            thread.setDaemon(true);
            thread.start();
        }
    }

    public List<String> reload() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.path != null) {
            long latestLastModified;
            File file = this.path.toFile();
            if (!file.exists()) {
                String message = this.path.toAbsolutePath() + " does not exist";
                messages.add(message);
                this.logger.warn(() -> message);
            }
            if (this.lastModified == (latestLastModified = file.lastModified())) {
                this.logger.debug(() -> this.path.toAbsolutePath() + " is not modified");
            }
            this.lastModified = latestLastModified;
            try {
                this.logger.info(() -> "loading: " + this.path.toAbsolutePath());
                List<String> lines = Files.readAllLines(this.path, StandardCharsets.UTF_8);
                messages.addAll(this.csv(lines));
            }
            catch (IOException io) {
                String message = "failed to load: " + this.path.toAbsolutePath();
                messages.add(message);
                this.logger.warn(() -> message, io);
            }
        }
        if (this.url != null) {
            try {
                this.logger.info(() -> "loading: " + this.url);
                URLConnection con = this.url.openConnection();
                con.setReadTimeout((int)Duration.of(1L, ChronoUnit.MINUTES).toMillis());
                con.setConnectTimeout((int)Duration.of(30L, ChronoUnit.SECONDS).toMillis());
                con.connect();
                ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
                try (InputStream is = con.getInputStream();){
                    int read;
                    while (-1 != (read = is.read())) {
                        out.write(read);
                    }
                }
                String content = out.toString(StandardCharsets.UTF_8);
                List<String> lines = Arrays.asList(content.split("\n"));
                messages.addAll(this.csv(lines));
            }
            catch (IOException e) {
                String message = "failed to connect: " + this.url;
                messages.add(message);
                this.logger.warn(() -> message, e);
            }
        }
        return messages;
    }

    Function<LocalDate, String> holiday() {
        return date -> this.builder.holiday().apply((LocalDate)date);
    }

    Function<LocalDate, List<BusinessHourSlot>> getBusinessHours() {
        return date -> this.builder.getBusinessHours().apply((LocalDate)date);
    }

    List<String> csv(List<String> lines) {
        ArrayList<String> warnings = new ArrayList<String>();
        BusinessCalendarBuilder newConf = new BusinessCalendarBuilder();
        DateTimeFormatter ymdFormat = DateTimeFormatter.ofPattern("yyyy/M/d");
        DateTimeFormatter mdFormat = DateTimeFormatter.ofPattern("M/d");
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (line.startsWith("#")) continue;
            String[] split = line.split(",");
            try {
                if (1 > split.length) continue;
                switch (split[0]) {
                    case "ymdFormat": {
                        ymdFormat = DateTimeFormatter.ofPattern(split[1]);
                        break;
                    }
                    case "mdFormat": {
                        mdFormat = DateTimeFormatter.ofPattern(split[1]);
                        break;
                    }
                    case "hours": {
                        this.on(newConf, ymdFormat, mdFormat, split, BusinessCalendarPredicate::hours);
                        break;
                    }
                    case "holiday": {
                        this.on(newConf, ymdFormat, mdFormat, split, BusinessCalendarPredicate::holiday);
                        break;
                    }
                    default: {
                        String message = "Skipping line[" + (i + 1) + "] (unable to parse): \"" + line + "\"";
                        warnings.add(message);
                        this.logger.warn(() -> message);
                    }
                }
                continue;
            }
            catch (Exception e) {
                String message = "Skipping line[" + (i + 1) + "] (unable to parse): \"" + line + "\"";
                warnings.add(message);
                this.logger.warn(() -> message);
            }
        }
        this.builder = newConf;
        return warnings;
    }

    private void on(@NotNull BusinessCalendarBuilder newConf, @NotNull DateTimeFormatter ymdFormatter, @NotNull DateTimeFormatter mdFormatter, @NotNull String[] lines, BiConsumer<BusinessCalendarPredicate, String> consumer) {
        try {
            try {
                LocalDate date2 = LocalDate.parse(lines[1], ymdFormatter);
                consumer.accept(new BusinessCalendarPredicate(date2, newConf), this.join(lines, 2));
            }
            catch (DateTimeParseException e1) {
                MonthDay parsed = MonthDay.parse(lines[1], mdFormatter);
                consumer.accept(new BusinessCalendarPredicate(date -> date.getMonth() == parsed.getMonth() && date.getDayOfMonth() == parsed.getDayOfMonth(), newConf), this.join(lines, 2));
            }
        }
        catch (DateTimeParseException e2) {
            try {
                this.parseWeekDays(newConf, lines, 2, Integer.valueOf(lines[1]), consumer);
            }
            catch (NumberFormatException nfe) {
                this.parseWeekDays(newConf, lines, 1, null, consumer);
            }
        }
    }

    private void parseWeekDays(@NotNull BusinessCalendarBuilder newConf, @NotNull String[] lines, int fromIndex, @Nullable Integer ordinal, BiConsumer<BusinessCalendarPredicate, String> consumer) {
        ArrayList<DayOfWeek> dayOfWeeks = new ArrayList<DayOfWeek>();
        while (fromIndex < lines.length) {
            String uppercase = lines[fromIndex].toUpperCase(Locale.ENGLISH);
            try {
                dayOfWeeks.add(DayOfWeek.valueOf(convert.getOrDefault(uppercase, uppercase)));
            }
            catch (IllegalArgumentException notDayOfWeek) {
                break;
            }
            ++fromIndex;
        }
        String buf = this.join(lines, fromIndex);
        DayOfWeek[] objects = dayOfWeeks.toArray(new DayOfWeek[0]);
        if (ordinal == null) {
            if (dayOfWeeks.isEmpty()) {
                consumer.accept(new BusinessCalendarPredicate(e -> true, newConf), buf);
            } else {
                consumer.accept(new BusinessCalendarPredicate(newConf, objects), buf);
            }
        } else {
            consumer.accept(new BusinessCalendarPredicate(newConf, ordinal, objects), buf);
        }
    }

    private String join(String[] split, int fromIndex) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (int i = fromIndex; i < split.length; ++i) {
            if (!first) {
                buf.append(",");
            }
            buf.append(split[i]);
            first = false;
        }
        return buf.toString();
    }
}

