/*
 * Decompiled with CFR 0.152.
 */
package one.cafebabe.webdriverinstaller;

import java.util.function.Supplier;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

final class Logger {
    private final java.util.logging.Logger jul;
    private final org.slf4j.Logger slf4j;
    static final boolean SLF4J_EXISTS_IN_CLASSPATH;

    Logger(java.util.logging.Logger julLogger, org.slf4j.Logger slf4jLogger) {
        this.jul = julLogger;
        this.slf4j = slf4jLogger;
    }

    public static void main(String[] args) {
        Logger.getLogger().debug(() -> "debug");
        Logger.getLogger().info(() -> "info");
        Logger.getLogger().warn(() -> "warn");
        Logger.getLogger().error(() -> "error");
    }

    @NotNull
    static Logger getLogger() {
        String className = new Throwable().getStackTrace()[1].getClassName();
        return SLF4J_EXISTS_IN_CLASSPATH ? new Logger(null, LoggerFactory.getLogger((String)className)) : new Logger(java.util.logging.Logger.getLogger(className), null);
    }

    void debug(Supplier<String> supplier) {
        if (SLF4J_EXISTS_IN_CLASSPATH) {
            if (this.slf4j.isDebugEnabled()) {
                this.slf4j.debug(supplier.get());
            }
        } else if (this.jul.isLoggable(Level.FINEST)) {
            this.jul.finest(supplier.get());
        }
    }

    void info(String message) {
        this.info(() -> message);
    }

    void info(Supplier<String> supplier) {
        if (SLF4J_EXISTS_IN_CLASSPATH) {
            if (this.slf4j.isInfoEnabled()) {
                this.slf4j.info(supplier.get());
            }
        } else if (this.jul.isLoggable(Level.INFO)) {
            this.jul.info(supplier.get());
        }
    }

    void warn(Supplier<String> supplier) {
        if (SLF4J_EXISTS_IN_CLASSPATH) {
            if (this.slf4j.isWarnEnabled()) {
                this.slf4j.warn(supplier.get());
            }
        } else if (this.jul.isLoggable(Level.WARNING)) {
            this.jul.warning(supplier.get());
        }
    }

    void warn(Supplier<String> supplier, Throwable th) {
        if (SLF4J_EXISTS_IN_CLASSPATH) {
            if (this.slf4j.isWarnEnabled()) {
                this.slf4j.warn(supplier.get(), th);
            }
        } else if (this.jul.isLoggable(Level.WARNING)) {
            this.jul.log(Level.WARNING, supplier.get(), th);
        }
    }

    void error(Supplier<String> supplier) {
        if (SLF4J_EXISTS_IN_CLASSPATH) {
            if (this.slf4j.isErrorEnabled()) {
                this.slf4j.error(supplier.get());
            }
        } else if (this.jul.isLoggable(Level.SEVERE)) {
            this.jul.severe(supplier.get());
        }
    }

    void error(Supplier<String> supplier, Throwable th) {
        if (SLF4J_EXISTS_IN_CLASSPATH) {
            if (this.slf4j.isErrorEnabled()) {
                this.slf4j.error(supplier.get(), th);
            }
        } else if (this.jul.isLoggable(Level.SEVERE)) {
            this.jul.log(Level.SEVERE, supplier.get(), th);
        }
    }

    static {
        boolean useSLF4J = false;
        try {
            Class.forName("org.slf4j.Logger");
            useSLF4J = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        SLF4J_EXISTS_IN_CLASSPATH = useSLF4J;
        Logger.getLogger().info(() -> SLF4J_EXISTS_IN_CLASSPATH ? "SLF4J Logger selected" : "jul Logger selected");
    }
}

