/*
 * Decompiled with CFR 0.152.
 */
package one.cafebabe.webdriverinstaller;

import java.util.Optional;
import one.cafebabe.webdriverinstaller.Logger;
import one.cafebabe.webdriverinstaller.WebDriverInstaller;

final class GeckodriverInstaller
extends WebDriverInstaller {
    private static final Logger logger = Logger.getLogger();

    public static void main(String ... args) {
        Optional<String> path;
        if (0 < args.length) {
            System.setProperty("geckodriver.home", args[0]);
        }
        if ((path = WebDriverInstaller.ensureGeckoDriverInstalled()).isPresent()) {
            logger.info(() -> "geckodriver installed at: " + (String)path.get());
        } else {
            logger.warn(() -> "Failed to install geckodriver");
        }
    }

    GeckodriverInstaller() {
        super("webdriver.gecko.driver", "Firefox", "geckodriver", "firefox", "/Applications/Firefox.app/Contents/MacOS/firefox-bin", "firefox.exe");
    }

    @Override
    String toFileName(String version) {
        String osString = this.choose("linux32", "linux64", "macos", "win32", "win64");
        String suffix = this.choose(".tar.gz", ".tar.gz", ".tar.gz", ".zip", ".zip");
        return String.format("geckodriver-%s-%s%s", version, osString, suffix);
    }

    @Override
    String getDownloadURL(String version, String fileName) {
        return String.format("https://github.com/mozilla/geckodriver/releases/download/%s/%s", version, fileName);
    }

    @Override
    String getSuitableDriverVersion(String firefoxVersion) {
        String version = firefoxVersion.trim().replaceAll("\\..*", "");
        int intVersion = Integer.parseInt(version);
        if (intVersion < 57) {
            return "v0.20.1";
        }
        if (intVersion < 60) {
            return "v0.25.0";
        }
        if (intVersion < 78) {
            return "v0.29.1";
        }
        return "v0.30.0";
    }
}

