/*
 * Decompiled with CFR 0.152.
 */
package one.cafebabe.webdriverinstaller;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import one.cafebabe.webdriverinstaller.ChromeDriverInstaller;
import one.cafebabe.webdriverinstaller.GeckodriverInstaller;
import one.cafebabe.webdriverinstaller.Logger;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;

public abstract class WebDriverInstaller {
    private static final Logger logger = Logger.getLogger();
    private final OS DETECTED_OS;
    private final String systemPropertyName;
    private final String appName;
    private final String driverName;
    private final String linuxApp;
    private final String macApp;
    private final String winApp;
    protected static final String CHROME_DRIVER_ENV_NAME = "CHROME_DRIVER_HOME";
    protected static final String CHROME_DRIVER_PROPERTY_NAME = "chromedriver.home";
    protected static final String GECKO_DRIVER_ENV_NAME = "GECKO_DRIVER_HOME";
    protected static final String GECKO_DRIVER_PROPERTY_NAME = "geckodriver.home";
    private boolean initialized = false;

    WebDriverInstaller(String systemPropertyName, String appName, String driverName, String linuxApp, String macApp, String winApp) {
        this.systemPropertyName = systemPropertyName;
        this.appName = appName;
        this.driverName = driverName;
        this.linuxApp = linuxApp;
        this.macApp = macApp;
        this.winApp = winApp;
        String arch = "" + System.getProperty("sun.arch.data.model") + System.getProperty("os.arch");
        String osName = System.getProperty("os.name").toLowerCase();
        this.DETECTED_OS = osName.contains("nux") ? (arch.contains("64") ? OS.LINUX64 : OS.LINUX32) : (osName.startsWith("windows") ? (arch.contains("64") ? OS.WINDOWS64 : OS.WINDOWS32) : (osName.contains("mac") || osName.contains("darwin") ? OS.MAC : OS.UNKNOWN));
    }

    public static Optional<String> ensureChromeDriverInstalled() {
        String chromeDriverHome = System.getenv(CHROME_DRIVER_ENV_NAME);
        String path = chromeDriverHome != null ? chromeDriverHome : System.getProperty(CHROME_DRIVER_PROPERTY_NAME, System.getProperty("user.home") + File.separator + "chromedriver");
        return new ChromeDriverInstaller().ensureInstalled(path);
    }

    public static Optional<String> ensureGeckoDriverInstalled() {
        String geckoDriverHome = System.getenv(GECKO_DRIVER_ENV_NAME);
        String path = geckoDriverHome != null ? geckoDriverHome : System.getProperty(GECKO_DRIVER_PROPERTY_NAME, System.getProperty("user.home") + File.separator + "geckodriver");
        return new GeckodriverInstaller().ensureInstalled(path);
    }

    synchronized Optional<String> ensureInstalled(String installRoot) {
        Optional<String> installedVersion = this.getInstalledAppVersion();
        if (!installedVersion.isPresent()) {
            return Optional.empty();
        }
        String browserVersion = installedVersion.get();
        String suitableDriverVersion = this.getSuitableDriverVersion(browserVersion);
        String binName = this.driverName + (this.isWin() ? ".exe" : "");
        String fileName = this.toFileName(suitableDriverVersion);
        Path installRootPath = Paths.get(installRoot, suitableDriverVersion);
        Path archivePath = installRootPath.resolve(fileName);
        Path bin = installRootPath.resolve(binName).toAbsolutePath();
        String nativeDriver = bin.toString();
        String downloadURL = this.getDownloadURL(suitableDriverVersion, fileName);
        if (!this.initialized) {
            try {
                if (Files.exists(bin, new LinkOption[0])) {
                    logger.info(nativeDriver + " already installed at: " + bin.toAbsolutePath());
                    this.initialized = true;
                } else {
                    WebDriverInstaller.download(downloadURL, archivePath, installRootPath, bin);
                }
                System.setProperty(this.systemPropertyName, nativeDriver);
                this.initialized = true;
            }
            catch (IOException ioe) {
                logger.warn(() -> "Failed to download: " + downloadURL);
                ioe.printStackTrace();
            }
        }
        return Optional.of(nativeDriver);
    }

    abstract String getSuitableDriverVersion(String var1);

    abstract String toFileName(String var1);

    abstract String getDownloadURL(String var1, String var2);

    String choose(String linux32, String linux64, String mac, String win32, String win64) {
        switch (this.DETECTED_OS) {
            case LINUX32: {
                return linux32;
            }
            case LINUX64: {
                return linux64;
            }
            case MAC: {
                return mac;
            }
            case WINDOWS32: {
                return win32;
            }
            case WINDOWS64: {
                return win64;
            }
        }
        return null;
    }

    public Optional<String> getInstalledAppVersion() {
        try {
            String appPath;
            switch (this.DETECTED_OS) {
                case MAC: {
                    appPath = this.macApp;
                    break;
                }
                case LINUX32: 
                case LINUX64: {
                    appPath = this.getAppPath(this.linuxApp);
                    break;
                }
                case WINDOWS32: 
                case WINDOWS64: {
                    appPath = this.getAppPath(this.winApp);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Not yet supported");
                }
            }
            if (!new File(appPath).exists()) {
                logger.warn(() -> "App not found at " + appPath);
                return Optional.empty();
            }
            String result = this.getAppVersion(appPath);
            String versionString = result.substring(result.lastIndexOf(" ") + 1);
            return Optional.of(versionString);
        }
        catch (IOException | InterruptedException e) {
            logger.warn(() -> "Failed to locate " + this.appName);
            e.printStackTrace();
            return Optional.empty();
        }
    }

    protected boolean isWin() {
        return this.DETECTED_OS == OS.WINDOWS32 || this.DETECTED_OS == OS.WINDOWS64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String execute(File directory, String[] commands) throws IOException, InterruptedException {
        File tempFile = File.createTempFile("chromeDriverInstaller", "out");
        tempFile.deleteOnExit();
        try {
            ProcessBuilder pb = new ProcessBuilder(commands).directory(directory).redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.to(tempFile));
            Process process = pb.start();
            process.waitFor();
            String output = new String(Files.readAllBytes(tempFile.toPath()));
            if (process.exitValue() != 0) {
                throw new IOException("Execution failed. commands: " + Arrays.toString(commands) + ", output:" + output);
            }
            String string = output.trim();
            return string;
        }
        finally {
            tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void download(String downloadURL, Path archivePath, Path installRootPath, Path bin) throws IOException {
        block5: {
            Files.createDirectories(installRootPath, new FileAttribute[0]);
            archivePath.toFile().delete();
            URL url = new URL(downloadURL);
            HttpURLConnection con = null;
            try {
                con = (HttpURLConnection)url.openConnection();
                con.setReadTimeout(5000);
                con.setConnectTimeout(5000);
                int code = con.getResponseCode();
                if (code == 200) {
                    Files.copy(con.getInputStream(), archivePath, new CopyOption[0]);
                    break block5;
                }
                throw new IOException("URL[" + url + "] returns code [" + code + "].");
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
        }
        WebDriverInstaller.decompress(archivePath, installRootPath);
        bin.toFile().setExecutable(true);
    }

    private static void unZip(Path toUnzip, Path root) throws IOException {
        ZipFile zip = new ZipFile(toUnzip.toFile());
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                try {
                    Files.createDirectories(root.resolve(entry.getName()), new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {}
                continue;
            }
            BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
            Throwable throwable = null;
            try {
                try {
                    Files.copy(is, root.resolve(entry.getName()), new CopyOption[0]);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    // empty catch block
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)is).close();
            }
        }
    }

    static void decompress(Path toDecompress, Path root) throws IOException {
        if (toDecompress.toString().matches(".*(tar.bz2|tar.gz)$")) {
            WebDriverInstaller.unTar(toDecompress, root);
        } else {
            WebDriverInstaller.unZip(toDecompress, root);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void unTar(Path toDecompress, Path root) throws IOException {
        File tarFile = File.createTempFile("driver", "tar");
        try (GZIPInputStream in = toDecompress.toString().endsWith(".gz") ? new GZIPInputStream(new FileInputStream(toDecompress.toFile())) : new BZip2CompressorInputStream((InputStream)new FileInputStream(toDecompress.toFile()));
             FileOutputStream out = new FileOutputStream(tarFile);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        File outputDir = root.toFile();
        outputDir.mkdirs();
        try (ArchiveInputStream is = new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)new FileInputStream(tarFile));){
            ArchiveEntry entry;
            while ((entry = is.getNextEntry()) != null) {
                FileOutputStream fos;
                block50: {
                    File out = new File(outputDir, entry.getName());
                    if (entry.isDirectory()) {
                        out.mkdirs();
                        continue;
                    }
                    fos = new FileOutputStream(out);
                    Throwable throwable = null;
                    try {
                        IOUtils.copy((InputStream)is, (OutputStream)fos);
                        if (fos == null) continue;
                        if (throwable == null) break block50;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable == null) {
                                ((OutputStream)fos).close();
                                throw throwable3;
                            }
                            try {
                                ((OutputStream)fos).close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        ((OutputStream)fos).close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                ((OutputStream)fos).close();
            }
        }
        catch (ArchiveException e) {
            throw new IOException(e);
        }
        tarFile.delete();
    }

    protected String getAppPath(String name) throws IOException, InterruptedException {
        return this.isWin() ? WebDriverInstaller.execute(new File("."), new String[]{"powershell", "-command", String.format("(Get-ItemProperty -ErrorAction Stop -Path \\\"HKLM:SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\%s\\\").'(default)'", name)}) : WebDriverInstaller.execute(new File("/"), new String[]{"/bin/bash", "-c", String.format("which '%s'", name)});
    }

    protected String getAppVersion(String appPath) throws IOException, InterruptedException {
        return this.isWin() ? WebDriverInstaller.execute(new File("."), new String[]{"powershell", "-command", "(Get-Item -ErrorAction Stop \\\"" + appPath + "\\\").VersionInfo.ProductVersion"}) : WebDriverInstaller.execute(new File("/"), new String[]{appPath, "-version", appPath});
    }

    static enum OS {
        MAC,
        LINUX32,
        LINUX64,
        WINDOWS32,
        WINDOWS64,
        UNKNOWN;

    }
}

