/*
 * Decompiled with CFR 0.152.
 */
package one.cafebabe.webdriverinstaller;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import one.cafebabe.webdriverinstaller.Logger;
import one.cafebabe.webdriverinstaller.WebDriverInstaller;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class ChromeDriverInstaller
extends WebDriverInstaller {
    private static final Logger logger = Logger.getLogger();

    public static void main(String ... args) {
        Optional<String> path;
        if (0 < args.length) {
            System.setProperty("chromedriver.home", args[0]);
        }
        if ((path = WebDriverInstaller.ensureChromeDriverInstalled()).isPresent()) {
            logger.info(() -> "ChromeDriver installed at: " + (String)path.get());
        } else {
            logger.warn(() -> "Failed to install ChromeDriver");
        }
    }

    ChromeDriverInstaller() {
        super("1", "Google Chrome", "chromedriver", "google-chrome", "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome", "chrome.exe");
    }

    @Override
    String toFileName(String version) {
        return "chromedriver_" + this.choose("linux32", "linux64", "mac64", "win32", "win32") + ".zip";
    }

    @Override
    String getDownloadURL(String version, String fileName) {
        return "https://chromedriver.storage.googleapis.com/" + version + "/" + fileName;
    }

    @Override
    String getSuitableDriverVersion(String installedVersion) {
        List<String> availableVersions = this.listAvailableChromeDriverVersions();
        return this.getSuitableDriverVersion(availableVersions, installedVersion);
    }

    String getSuitableDriverVersion(List<String> availableVersions, String installedVersion) {
        this.listAvailableChromeDriverVersions();
        if (availableVersions.contains(installedVersion)) {
            return installedVersion;
        }
        logger.info(String.format("ChromeDriver version %s is not available.", installedVersion));
        String fallbackVersion = null;
        block0: while (fallbackVersion == null && installedVersion.contains(".")) {
            installedVersion = installedVersion.substring(0, installedVersion.lastIndexOf("."));
            for (int i = availableVersions.size() - 1; 0 <= i; --i) {
                if (!availableVersions.get(i).contains(installedVersion)) continue;
                fallbackVersion = availableVersions.get(i);
                continue block0;
            }
        }
        if (fallbackVersion == null) {
            int installedMajorVersion = Integer.parseInt(installedVersion);
            block2: for (int i = installedMajorVersion - 1; 0 < i && fallbackVersion == null; --i) {
                String checkVersion = String.valueOf(i);
                for (int j = availableVersions.size() - 1; 0 <= j; --j) {
                    String majorVersion = availableVersions.get(j).substring(0, availableVersions.get(j).indexOf("."));
                    if (!majorVersion.contains(checkVersion)) continue;
                    fallbackVersion = availableVersions.get(j);
                    continue block2;
                }
            }
        }
        assert (fallbackVersion != null);
        logger.info(String.format("Fallback to Chrome Driver version %s.", fallbackVersion));
        return fallbackVersion;
    }

    List<String> listAvailableChromeDriverVersions() {
        try {
            URLConnection con = new URL("https://chromedriver.storage.googleapis.com/?delimiter=/&prefix=").openConnection();
            con.setConnectTimeout(5000);
            con.setReadTimeout(5000);
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(con.getInputStream());
            NodeList prefix = doc.getElementsByTagName("Prefix");
            ArrayList<String> versions = new ArrayList<String>();
            for (int i = 0; i < prefix.getLength(); ++i) {
                String textContent = prefix.item(i).getTextContent();
                if (!textContent.matches("[0-9./]+")) continue;
                versions.add(textContent.replace("/", ""));
            }
            return versions;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }
}

