/*
 * Decompiled with CFR 0.152.
 */
package one.cafebabe.webdriverinstaller;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import java.util.Properties;
import one.cafebabe.webdriverinstaller.Logger;
import one.cafebabe.webdriverinstaller.WebDriverInstaller;

final class GeckodriverInstaller
extends WebDriverInstaller {
    private static final Logger logger = Logger.getLogger();
    static final String[] versions;

    public static void main(String ... args) {
        Optional<String> path;
        if (0 < args.length) {
            System.setProperty("geckodriver.home", args[0]);
        }
        if ((path = WebDriverInstaller.ensureGeckoDriverInstalled()).isPresent()) {
            logger.info(() -> "geckodriver installed at: " + (String)path.get());
        } else {
            logger.warn(() -> "Failed to install geckodriver");
        }
    }

    GeckodriverInstaller() {
        super("webdriver.gecko.driver", "Firefox", "geckodriver", "firefox", "/Applications/Firefox.app/Contents/MacOS/firefox-bin", "firefox.exe");
    }

    @Override
    String toFileName(String version) {
        String osString = this.choose("linux32", "linux64", "macos", "win32", "win64");
        String suffix = this.choose(".tar.gz", ".tar.gz", ".tar.gz", ".zip", ".zip");
        return String.format("geckodriver-%s-%s%s", version, osString, suffix);
    }

    @Override
    String getDownloadURL(String version, String fileName) {
        return String.format("https://github.com/mozilla/geckodriver/releases/download/%s/%s", version, fileName);
    }

    @Override
    String getSuitableDriverVersion(String firefoxVersion) {
        String version = firefoxVersion.trim().replaceAll("\\..*", "");
        int intVersion = Integer.parseInt(version);
        for (String s : versions) {
            String driverVersion = s.split("<")[0];
            int geckoVersion = Integer.parseInt(s.split("<")[1]);
            if (intVersion >= geckoVersion) continue;
            return driverVersion;
        }
        return versions[versions.length - 1].split("<")[1];
    }

    static {
        Properties p = new Properties();
        try {
            p.load(GeckodriverInstaller.class.getResourceAsStream("/gecko-versions.properties"));
            URL url = new URL("https://raw.githubusercontent.com/Samuraism/webdriver-installer/main/resources/gecko-versions.properties");
            URLConnection urlConnection = url.openConnection();
            p.load(urlConnection.getInputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        versions = p.getProperty("gecko-versions").split(",");
    }
}

