/*
 * MIT License
 *
 * Copyright (c) 2018 Mikhalev Ruslan
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package one.chest

import com.mongodb.client.FindIterable
import com.mongodb.client.MongoCollection
import com.mongodb.client.MongoDatabase
import groovy.transform.CompileStatic
import org.bson.BsonDocument
import org.bson.BsonObjectId
import org.bson.Document
import org.bson.types.ObjectId

import static com.mongodb.client.model.Filters.and
import static com.mongodb.client.model.Filters.eq

@CompileStatic
class MongoDBExtensionMethods {

    static MongoCollection<Document> getAt(MongoDatabase database, String collectionName) {
        return database.getCollection(collectionName)
    }

    static String leftShift(MongoCollection<Document> collection, Map<String, ? extends Object> values) {
        def doc = new Document(values)
        collection.insertOne(doc)
        return doc["_id"]
    }

    static Document getAt(MongoCollection<Document> collection, String id) {
        collection.find(new BsonDocument().append("_id", new BsonObjectId(new ObjectId(id)))).first()
    }

    static FindIterable<Document> find(MongoCollection<Document> collection, Map<String, ? extends Object> values) {
        collection.find(
                and(values.entrySet().collect({ eq(it.key, it.value) }))
        )
    }

    static FindIterable<Document> filter(FindIterable<Document> iterable, Map<String, ? extends Object> values) {
        iterable.filter(
                and(values.entrySet().collect({ eq(it.key, it.value) }))
        )
    }

}
