/*
 * Decompiled with CFR 0.152.
 */
package one.chest.musiclibrary;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import jdk.nashorn.api.scripting.ScriptUtils;
import one.chest.musiclibrary.exception.MusicLibraryException;

class JSResponseHandler {
    private ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");

    JSResponseHandler() {
        BiFunction<ScriptObjectMirror, ScriptObjectMirror, Object[]> consumer = JSResponseHandler::suggest;
        this.engine.put("suggest", consumer);
    }

    private static Object[] suggest(ScriptObjectMirror arr, ScriptObjectMirror junk) {
        return (Object[])ScriptUtils.convert((Object)arr.getSlot(1), Object[].class);
    }

    List<String> parseSuggestionToList(String js) {
        try {
            Object[] scriptResponse = (Object[])this.engine.eval(js);
            return Arrays.stream(scriptResponse).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList());
        }
        catch (ClassCastException | ScriptException e) {
            throw new MusicLibraryException("Can't handle js: " + js, e);
        }
    }
}

