/*
 * Decompiled with CFR 0.152.
 */
package one.chest.musiclibrary;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.util.List;
import java.util.stream.Collectors;
import one.chest.musiclibrary.JSResponseHandler;
import one.chest.musiclibrary.MusicGuesser;
import one.chest.musiclibrary.exception.MusicLibraryException;

public final class MusicGuesserImpl
implements MusicGuesser {
    private final String host;
    private final JSResponseHandler jsResponseHandler = new JSResponseHandler();

    MusicGuesserImpl(String libraryHost) {
        this.host = libraryHost;
    }

    static String formatSong(String s) {
        return MusicGuesserImpl.capitalize(s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase());
    }

    static String capitalize(String text) {
        StringBuilder sb = new StringBuilder();
        boolean toCapital = false;
        for (char c : text.toCharArray()) {
            char cUpperCaseCharacter;
            if (c == '-') {
                toCapital = false;
            }
            if (c == '.' || c == '!' || c == '?') {
                toCapital = true;
                sb.append(c);
                continue;
            }
            if (toCapital && (cUpperCaseCharacter = Character.toUpperCase(c)) != c) {
                toCapital = false;
                sb.append(cUpperCaseCharacter);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public List<String> suggest(String part) {
        try {
            HttpResponse js = Unirest.get((String)this.host.concat("/suggest-ya.cgi")).queryString("part", (Object)part).asString();
            return this.jsResponseHandler.parseSuggestionToList((String)js.getBody()).stream().filter(s -> s.length() > 1).map(MusicGuesserImpl::formatSong).collect(Collectors.toList());
        }
        catch (UnirestException e) {
            throw new MusicLibraryException("Error while suggest track", e);
        }
    }
}

