/*
 * Decompiled with CFR 0.152.
 */
package one.chest.musiclibrary;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.GetRequest;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import one.chest.musiclibrary.MusicLibrary;
import one.chest.musiclibrary.Track;
import one.chest.musiclibrary.TrackExtractor;
import one.chest.musiclibrary.TrackImpl;
import one.chest.musiclibrary.TrackLocation;
import one.chest.musiclibrary.TrackLocationFetcher;
import one.chest.musiclibrary.exception.InvalidTrackLocationException;
import one.chest.musiclibrary.exception.MusicLibraryException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.json.JSONArray;
import org.json.JSONObject;

public final class MusicLibraryImpl
implements MusicLibrary {
    private final String host;
    private final TrackLocationFetcher trackLocationFetcher;
    private final BasicCookieStore cookieStore = new BasicCookieStore();

    MusicLibraryImpl(String libraryHost) {
        this.host = libraryHost;
        this.trackLocationFetcher = new TrackLocationFetcher();
        Unirest.setHttpClient((HttpClient)this.createHttpClient());
        this.addCookie("UUID", UUID.randomUUID().toString());
    }

    private HttpClient createHttpClient() {
        return HttpClients.custom().setDefaultCookieStore((CookieStore)this.cookieStore).build();
    }

    private void addCookie(String name, String value) {
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        cookie.setDomain(this.host);
        this.cookieStore.addCookie((Cookie)cookie);
    }

    @Override
    public List<Track> searchTracks(String artist, String song) {
        try {
            HttpResponse response = Unirest.get((String)this.host.concat("/handlers/music-search.jsx")).queryString("text", (Object)(artist + " " + song)).queryString("type", (Object)"track").queryString("nocookiesupport", (Object)"true").header("Accept-Language", "ru").header("X-Retpath-Y", this.host).asJson();
            JSONObject tracks = ((JsonNode)response.getBody()).getObject().getJSONObject("tracks");
            return new TrackExtractor(artist).fromJSON(tracks);
        }
        catch (UnirestException e) {
            throw new MusicLibraryException("Error while search track", e);
        }
    }

    @Override
    public Optional<Track> searchTrack(String artist, String song) {
        List<Track> tracks = this.searchTracks(artist, song);
        return tracks.size() > 0 ? Optional.of(tracks.get(0)) : Optional.empty();
    }

    @Override
    public Track getTrack(TrackLocation trackLocation) {
        try {
            HttpResponse response = Unirest.get((String)this.host.concat("/handlers/track.jsx?track={trackId}:{albumId}")).routeParam("trackId", String.valueOf(trackLocation.getTrackId())).routeParam("albumId", String.valueOf(trackLocation.getAlbumId())).header("Accept-Language", "ru").header("X-Retpath-Y", this.host).asJson();
            JSONObject track = ((JsonNode)response.getBody()).getObject().getJSONObject("track");
            JSONArray artistNode = track.getJSONArray("artists");
            assert (artistNode.length() == 1);
            String artistName = ((JSONObject)artistNode.get(0)).getString("name");
            return TrackImpl.fromJson(artistName, track);
        }
        catch (UnirestException e) {
            throw new MusicLibraryException("Error while fetching track metadata", e);
        }
    }

    @Override
    public InputStream fetchInputStream(Track track) {
        return this.fetchInputStream(track.getTrackLocation());
    }

    @Override
    public InputStream fetchInputStream(TrackLocation trackLocation) {
        try {
            String downloadLink = this.getDownloadLink(trackLocation);
            return (InputStream)Unirest.get((String)downloadLink).header("X-Retpath-Y", this.host).asBinary().getBody();
        }
        catch (UnirestException e) {
            throw new MusicLibraryException("Error while building track download URI", e);
        }
    }

    public String getDownloadLink(TrackLocation trackLocation) throws UnirestException {
        GetRequest request = Unirest.get((String)this.host.concat("/api/v2.1/handlers/track/{trackId}:{albumId}/web-feed-promotion-playlist-saved/download/m?hq=0")).routeParam("trackId", String.valueOf(trackLocation.getTrackId())).routeParam("albumId", String.valueOf(trackLocation.getAlbumId())).header("Accept-Language", "ru").header("X-Retpath-Y", this.host);
        HttpResponse response = request.asJson();
        if (response.getStatus() == 403) {
            throw new InvalidTrackLocationException("Invalid location: " + request.getUrl());
        }
        if (response.getStatus() != 200) {
            throw new MusicLibraryException("Invalid response status: " + response.getStatus() + ". Reason: " + response.getStatusText());
        }
        String locationHolderURL = ((JsonNode)response.getBody()).getObject().getString("src");
        JSONObject json = ((JsonNode)Unirest.get((String)locationHolderURL).queryString("format", (Object)"json").asJson().getBody()).getObject();
        return this.trackLocationFetcher.createTrackURI(trackLocation.getTrackId(), json.getString("host"), json.getString("path"), json.getString("ts"), json.getString("s"));
    }
}

