/*
 * Decompiled with CFR 0.152.
 */
package one.chest.musiclibrary;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import one.chest.musiclibrary.Track;
import one.chest.musiclibrary.TrackImpl;
import org.json.JSONArray;
import org.json.JSONObject;

final class TrackExtractor {
    private final String artist;

    TrackExtractor(String artist) {
        this.artist = artist;
    }

    List<Track> fromJSON(JSONObject tracks) {
        JSONArray items = tracks.getJSONArray("items");
        return StreamSupport.stream(items.spliterator(), false).map(o -> (JSONObject)o).filter(this::filterByArtistName).filter(i -> i.getJSONArray("albums").length() > 0).map(i -> TrackImpl.fromJson(this.artist, i)).collect(Collectors.toList());
    }

    boolean filterByArtistName(JSONObject jsonObject) {
        JSONArray artists = jsonObject.getJSONArray("artists");
        return StreamSupport.stream(artists.spliterator(), false).anyMatch(a -> this.artist.equals(((JSONObject)a).getString("name")));
    }
}

