/*
 * Decompiled with CFR 0.152.
 */
package one.chest.musiclibrary;

import java.util.Objects;
import one.chest.musiclibrary.Track;
import one.chest.musiclibrary.TrackLocation;
import org.json.JSONObject;

class TrackImpl
implements Track {
    private final TrackLocation trackLocation;
    private final String artist;
    private final String name;
    private final Long duration;

    TrackImpl(TrackLocation trackLocation, String artist, String song, Long duration) {
        this.trackLocation = Objects.requireNonNull(trackLocation);
        this.artist = Objects.requireNonNull(artist);
        this.name = Objects.requireNonNull(song);
        this.duration = duration;
    }

    public static Track fromJson(String artist, JSONObject i) {
        int albumId = ((JSONObject)i.getJSONArray("albums").get(0)).getInt("id");
        int trackId = i.getInt("id");
        TrackLocation trackLocation = new TrackLocation(albumId, trackId);
        return new TrackImpl(trackLocation, artist, i.getString("title"), i.getLong("durationMs"));
    }

    @Override
    public TrackLocation getTrackLocation() {
        return this.trackLocation;
    }

    @Override
    public String getArtist() {
        return this.artist;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Long getDuration() {
        return this.duration;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TrackImpl)) {
            return false;
        }
        TrackImpl other = (TrackImpl)obj;
        return (this.artist != null && this.artist.equals(other.getArtist()) || other.artist == null) && (this.name != null && this.name.equals(other.getName()) || other.name == null) && (this.duration != null && this.duration.equals(other.getDuration()) || other.duration == null) && (this.trackLocation != null && this.trackLocation.equals(other.trackLocation) || other.trackLocation == null);
    }

    public String toString() {
        return String.format("[%s]%s - %s (%sms)", this.trackLocation, this.artist, this.name, this.duration);
    }
}

