/*
 * Decompiled with CFR 0.152.
 */
package one.chest.musiclibrary;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import one.chest.musiclibrary.exception.MusicLibraryException;

public class TrackLocationFetcher {
    private final MessageDigest signer;
    private static final char[] hexCode = "0123456789ABCDEF".toCharArray();

    TrackLocationFetcher() {
        try {
            this.signer = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new MusicLibraryException("Signer initialization error", e);
        }
    }

    String createTrackURI(int trackId, String host, String path, String ts, String s) {
        String hash = this.md5("XGRlBW9FXlekgbPrRHuSiA" + path.substring(1) + s);
        return "https://" + host + "/get-mp3/" + hash + "/" + ts + path + "?track-id=" + trackId;
    }

    private String md5(String source) {
        try {
            return this.toHexString(this.signer.digest(source.getBytes("utf8"))).toLowerCase();
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF8 encoding is unsupported!");
        }
    }

    private String toHexString(byte[] data) {
        if (data == null) {
            return null;
        }
        StringBuilder r = new StringBuilder(data.length * 2);
        for (byte b : data) {
            r.append(hexCode[b >> 4 & 0xF]);
            r.append(hexCode[b & 0xF]);
        }
        return r.toString();
    }
}

