/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Pair;
import one.edee.babylon.export.MessageFileProcessor;
import one.edee.babylon.export.MessageLoader;
import one.edee.babylon.export.SheetContent;
import one.edee.babylon.export.dto.ExportResult;
import one.edee.babylon.export.dto.MessageFileExportResult;
import one.edee.babylon.export.dto.TranslationSheet;
import one.edee.babylon.export.stats.MessageFileExportStats;
import one.edee.babylon.sheets.SheetUtils;
import one.edee.babylon.snapshot.TranslationSnapshotReadContract;
import one.edee.babylon.snapshot.TranslationSnapshotWriteContract;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TranslationCollector {
    private static final Log log = LogFactory.getLog(TranslationCollector.class);
    private final MessageLoader messageLoader;
    private final MessageFileProcessor messageFileProcessor;
    private final TranslationSnapshotReadContract snapshotReadContract;
    private final TranslationSnapshotWriteContract snapshotWriteContract;

    public ExportResult walkPathsAndCollectTranslationSheets(Collection<String> allPaths, List<String> translateTo) {
        List<String> newMsgFilesPaths = allPaths.stream().filter(msgFilePath -> !this.snapshotReadContract.includesMsgFile((String)msgFilePath)).collect(Collectors.toList());
        List<MessageFileExportResult> sheetsAndStats = allPaths.stream().map(msgFilePath -> this.processMsgFile((String)msgFilePath, translateTo)).collect(Collectors.toList());
        List<TranslationSheet> sheets = this.getSheets(sheetsAndStats);
        List<MessageFileExportStats> exportStats = this.getStats(sheetsAndStats);
        this.logMsgFileStats(exportStats);
        List<String> obsoleteFilePaths = this.snapshotReadContract.listMsgFiles().stream().filter(msgFilePath -> !allPaths.contains(msgFilePath)).collect(Collectors.toList());
        this.snapshotWriteContract.removeMsgFilePaths(obsoleteFilePaths);
        return new ExportResult(newMsgFilesPaths, sheets);
    }

    private List<TranslationSheet> getSheets(List<MessageFileExportResult> sheetsAndStats) {
        return sheetsAndStats.stream().map(MessageFileExportResult::getTranslationSheet).collect(Collectors.toList());
    }

    private List<MessageFileExportStats> getStats(List<MessageFileExportResult> sheetsAndStats) {
        return sheetsAndStats.stream().map(MessageFileExportResult::getExportStats).collect(Collectors.toList());
    }

    private MessageFileExportResult processMsgFile(String msgFilePath, List<String> translateTo) {
        Pair<SheetContent, MessageFileExportStats> msgFileResult = this.computeTranslationSheetRows(msgFilePath, translateTo);
        SheetContent sheetData = (SheetContent)msgFileResult.getFirst();
        MessageFileExportStats msgFileStats = (MessageFileExportStats)msgFileResult.getSecond();
        Integer sheetId = this.snapshotWriteContract.registerMsgFile(msgFilePath);
        TranslationSheet translationSheet = this.newTranslationSheet(sheetData, sheetId, msgFilePath, translateTo);
        return new MessageFileExportResult(translationSheet, msgFileStats);
    }

    private Pair<SheetContent, MessageFileExportStats> computeTranslationSheetRows(String msgFilePath, List<String> translateTo) {
        Map<String, String> primaryMsgs = this.messageLoader.loadPrimaryMessages(msgFilePath);
        Map<String, Map<String, String>> translations = this.messageLoader.loadTranslations(msgFilePath, translateTo);
        return this.messageFileProcessor.prepareTranslationSheet(msgFilePath, primaryMsgs, translations, translateTo);
    }

    private TranslationSheet newTranslationSheet(SheetContent sheetContent, Integer sheetId, String msgFilePath, List<String> translateTo) {
        String sheetName = new SheetUtils().getSheetName(msgFilePath, sheetId);
        ArrayList<List<String>> allRows = new ArrayList<List<String>>();
        allRows.addAll(Collections.singletonList(sheetContent.getHeader()));
        allRows.addAll(sheetContent.getDataRows());
        return new TranslationSheet(sheetName, allRows);
    }

    private void logMsgFileStats(Iterable<MessageFileExportStats> exportStats) {
        exportStats.forEach(this::logMsgFileStats);
    }

    private void logMsgFileStats(MessageFileExportStats msgFileStats) {
        String msg = msgFileStats.getMessageFilePath() + ": \n\t" + msgFileStats.getNewPrimaryMsgKeyCount() + " new messages, \n\t" + msgFileStats.getChangedPrimaryMsgKeyCount() + " messages with changed values in primary language, \n\t" + msgFileStats.getMissingTranslationMsgKeyCount() + " messages with some translations missing.\n\t" + msgFileStats.getSheetDataRows() + " total rows in translation sheet.";
        log.info((Object)msg);
    }

    public TranslationCollector(MessageLoader messageLoader, MessageFileProcessor messageFileProcessor, TranslationSnapshotReadContract snapshotReadContract, TranslationSnapshotWriteContract snapshotWriteContract) {
        this.messageLoader = messageLoader;
        this.messageFileProcessor = messageFileProcessor;
        this.snapshotReadContract = snapshotReadContract;
        this.snapshotWriteContract = snapshotWriteContract;
    }
}

