/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.snapshot;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import one.edee.babylon.entity.MessageFileContent;

public class Snapshot
implements Serializable {
    private static final long serialVersionUID = 4891061639828627492L;
    Map<String, MessageFileContent> dataPropFiles = new LinkedHashMap<String, MessageFileContent>();
    @JsonIgnore
    Map<Integer, MessageFileContent> dataPropFilesById = new LinkedHashMap<Integer, MessageFileContent>();

    public MessageFileContent putPropFile(String fileName, MessageFileContent messageFileContent) {
        MessageFileContent propFile = this.dataPropFiles.put(fileName, messageFileContent);
        Integer fileNameId = this.getNextUniqueId();
        messageFileContent.setId(fileNameId);
        this.putDataPropFileById(fileNameId, messageFileContent);
        return propFile;
    }

    public MessageFileContent putDataPropFileById(Integer fileNameId, MessageFileContent messageFileContent) {
        return this.dataPropFilesById.put(fileNameId, messageFileContent);
    }

    public MessageFileContent getOrPutNewPropFileByFileName(String fileName) {
        MessageFileContent messageFileContent = this.dataPropFiles.get(fileName);
        if (messageFileContent == null) {
            messageFileContent = new MessageFileContent();
            this.putPropFile(fileName, messageFileContent);
        }
        return messageFileContent;
    }

    public MessageFileContent getPropFileByFileName(String fileName) {
        return this.dataPropFiles.get(fileName);
    }

    public MessageFileContent getPropFileById(Integer id) {
        return this.dataPropFilesById.get(id);
    }

    private Integer getNextUniqueId() {
        Set<Integer> ids = this.dataPropFilesById.keySet();
        if (ids.isEmpty()) {
            return 0;
        }
        Optional maxId = ids.stream().reduce(Integer::max);
        return (Integer)maxId.get() + 1;
    }

    public Map<String, MessageFileContent> getDataPropFiles() {
        return this.dataPropFiles;
    }

    public Map<Integer, MessageFileContent> getDataPropFilesById() {
        return this.dataPropFilesById;
    }

    public void setDataPropFiles(Map<String, MessageFileContent> dataPropFiles) {
        this.dataPropFiles = dataPropFiles;
    }

    public void setDataPropFilesById(Map<Integer, MessageFileContent> dataPropFilesById) {
        this.dataPropFilesById = dataPropFilesById;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, MessageFileContent> this$dataPropFiles = this.getDataPropFiles();
        Map<String, MessageFileContent> other$dataPropFiles = other.getDataPropFiles();
        if (this$dataPropFiles == null ? other$dataPropFiles != null : !((Object)this$dataPropFiles).equals(other$dataPropFiles)) {
            return false;
        }
        Map<Integer, MessageFileContent> this$dataPropFilesById = this.getDataPropFilesById();
        Map<Integer, MessageFileContent> other$dataPropFilesById = other.getDataPropFilesById();
        return !(this$dataPropFilesById == null ? other$dataPropFilesById != null : !((Object)this$dataPropFilesById).equals(other$dataPropFilesById));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Snapshot;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, MessageFileContent> $dataPropFiles = this.getDataPropFiles();
        result = result * 59 + ($dataPropFiles == null ? 43 : ((Object)$dataPropFiles).hashCode());
        Map<Integer, MessageFileContent> $dataPropFilesById = this.getDataPropFilesById();
        result = result * 59 + ($dataPropFilesById == null ? 43 : ((Object)$dataPropFilesById).hashCode());
        return result;
    }

    public String toString() {
        return "Snapshot(dataPropFiles=" + this.getDataPropFiles() + ", dataPropFilesById=" + this.getDataPropFilesById() + ")";
    }
}

