/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.export;

import de.poiu.apron.PropertyFile;
import de.poiu.apron.entry.PropertyEntry;
import java.io.File;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import one.edee.babylon.export.MessageLoader;
import one.edee.babylon.msgfile.TranslationFileUtils;
import one.edee.babylon.util.FileUtils;

public class ApronMessageLoader
implements MessageLoader {
    public Map<String, String> loadPrimaryMessages(String filePath) {
        return this.dumpPropertyFile(filePath);
    }

    public Map<String, Map<String, String>> loadTranslations(String filePath, List<String> languages) {
        return languages.stream().map(lang -> new AbstractMap.SimpleEntry<String, Map>((String)lang, this.loadTranslations(filePath, lang))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private Map<String, String> loadTranslations(String filePath, String language) {
        String translationFilePath = TranslationFileUtils.getFileNameForTranslation((String)filePath, (String)language);
        return this.dumpPropertyFile(translationFilePath);
    }

    private Map<String, String> dumpPropertyFile(String filePath) {
        PropertyFile primaryMsgs = FileUtils.exists((String)filePath) ? PropertyFile.from((File)this.fileFromPath(filePath)) : new PropertyFile();
        return this.dumpPropertyFile(primaryMsgs);
    }

    private Map<String, String> dumpPropertyFile(PropertyFile propertyFile) {
        return propertyFile.getAllEntries().stream().filter(entry -> entry instanceof PropertyEntry).map(propEntry -> new AbstractMap.SimpleEntry<String, String>(((PropertyEntry)propEntry).getKey().toString(), this.cleanPropertyValue(((PropertyEntry)propEntry).getValue().toString()))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    String cleanPropertyValue(String rawValue) {
        return rawValue.trim();
    }

    private File fileFromPath(String path) {
        return FileUtils.fileFromPathOrThrow((String)path);
    }
}

