/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.snapshot;

import java.util.Collection;
import java.util.NoSuchElementException;
import one.edee.babylon.entity.MessageFileContent;
import one.edee.babylon.entity.PropertiesMap;
import one.edee.babylon.snapshot.Snapshot;
import one.edee.babylon.snapshot.TranslationSnapshotReadContract;
import one.edee.babylon.snapshot.TranslationSnapshotWriteContract;

public class SnapshotAdapter
implements TranslationSnapshotReadContract,
TranslationSnapshotWriteContract {
    private final Snapshot snapshot;

    public SnapshotAdapter(Snapshot snapshot) {
        this.snapshot = snapshot;
    }

    @Override
    public Snapshot getUnderlyingSnapshot() {
        return this.snapshot;
    }

    @Override
    public boolean includesMsgFile(String msgFile) {
        return this.snapshot.getPropFileByFileName(msgFile) != null;
    }

    @Override
    public Collection<String> listMsgFiles() {
        return this.snapshot.dataPropFiles.keySet();
    }

    @Override
    public Integer registerMsgFile(String msgFilePath) {
        MessageFileContent messageFileContent = this.snapshot.getOrPutNewPropFileByFileName(msgFilePath);
        return messageFileContent.getId();
    }

    @Override
    public void removeMsgFilePaths(Collection<String> msgFilePaths) {
        this.snapshot.dataPropFiles.keySet().removeAll(msgFilePaths);
    }

    @Override
    public boolean containsMessage(String msgKey, String msgFile) {
        if (!this.includesMsgFile(msgFile)) {
            return false;
        }
        return this.containsMessageInProps(msgKey, this.getTranslationProperties(msgFile));
    }

    private boolean containsMessageInProps(String msgKey, PropertiesMap msgProps) {
        return msgProps.containsKey(msgKey) && msgProps.get(msgKey) != null && !((String)msgProps.get(msgKey)).isEmpty();
    }

    private PropertiesMap getTranslationProperties(String msgFile) {
        if (!this.includesMsgFile(msgFile)) {
            throw new NoSuchElementException("Translation snapshot doesn't contain message file '$msgFile'.");
        }
        return this.snapshot.getPropFileByFileName(msgFile).getProperties();
    }

    @Override
    public String getLastMessageValue(String msgKey, String msgFile) {
        PropertiesMap msgProps = this.getTranslationProperties(msgFile);
        if (!this.containsMessageInProps(msgKey, msgProps)) {
            String errMsg = "No message for key '" + msgKey + "' in '" + msgFile + "' message file snapshot.";
            throw new NoSuchElementException(errMsg);
        }
        return (String)msgProps.get(msgKey);
    }
}

