/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.sheets.gsheets.executor;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.json.GenericJson;
import com.google.api.services.sheets.v4.Sheets;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.TimeUnit;
import one.edee.babylon.sheets.gsheets.GSheetsClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;

public abstract class RateLimitingRequestExecutor<T extends GenericJson, U extends GenericJson> {
    private static final Log log = LogFactory.getLog(RateLimitingRequestExecutor.class);
    private static final int HTTP_TOO_MANY_REQUESTS = 429;
    static final int MAX_BACKOFF_TIME_SEC = 64;
    static final int MAX_RETRIES = 50;
    protected final GSheetsClient gsClient;
    protected final String spreadsheetId;
    @Nullable
    private T request;

    public RateLimitingRequestExecutor(GSheetsClient gsClient, String spreadsheetId, @Nullable T request) {
        this.gsClient = gsClient;
        this.request = request;
        this.spreadsheetId = spreadsheetId;
    }

    public U executeRequest() throws GeneralSecurityException, IOException {
        int backoffTime = 1;
        int retries = 0;
        U result = null;
        while (this.request != null && retries < 50) {
            try {
                result = this.executeRequest(this.request);
                this.request = null;
            }
            catch (GoogleJsonResponseException gjre) {
                if (gjre.getStatusCode() != 429) continue;
                log.warn((Object)gjre.getDetails());
                this.sleepFor(backoffTime);
                backoffTime *= 2;
                backoffTime = Math.min(backoffTime, 64);
                ++retries;
            }
        }
        return result;
    }

    abstract U executeRequest(T var1) throws GeneralSecurityException, IOException;

    private void sleepFor(int seconds) {
        try {
            String secStr = seconds == 1 ? "second" : "seconds";
            log.info((Object)("API rate limit exceeded. Pausing for " + seconds + " " + secStr + "."));
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error((Object)"Thread interrupted while sleeping before next attempt at HTTP request!");
        }
    }

    protected Sheets getSheetsClient() throws GeneralSecurityException, IOException {
        return this.gsClient.getSheetService();
    }
}

