/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.export;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.edee.babylon.db.SnapshotUtils;
import one.edee.babylon.export.Exporter;
import one.edee.babylon.export.TranslationCollector;
import one.edee.babylon.export.dto.ExportResult;
import one.edee.babylon.sheets.SheetsException;
import one.edee.babylon.sheets.gsheets.model.ASheet;
import one.edee.babylon.snapshot.Snapshot;
import one.edee.babylon.snapshot.TranslationSnapshotWriteContract;
import one.edee.babylon.util.AntPathResourceLoader;
import one.edee.babylon.util.PathUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Exporter {
    private static final Log log = LogFactory.getLog(Exporter.class);
    private final TranslationCollector translationCollector;
    private final TranslationSnapshotWriteContract snapshot;
    private final SheetContract gsc;
    private final AntPathResourceLoader resourceLoader;
    private final PathUtils pu;

    public Exporter(TranslationCollector translationCollector, TranslationSnapshotWriteContract snapshot, SheetContract gsc, AntPathResourceLoader resourceLoader) {
        this.translationCollector = translationCollector;
        this.snapshot = snapshot;
        this.gsc = gsc;
        this.resourceLoader = resourceLoader;
        this.pu = new PathUtils();
    }

    public void walkPathsAndWriteSheets(List<String> patternPaths, List<String> translationLangs, String spreadsheetId, Path snapshotPath) {
        this.walkPathsAndWriteSheets(patternPaths, translationLangs, spreadsheetId, snapshotPath, Collections.emptyList());
    }

    public void walkPathsAndWriteSheets(List<String> patternPaths, List<String> translationLangs, String spreadsheetId, Path snapshotPath, List<String> lockedCellEditors) {
        this.warnDuplicatePaths(patternPaths);
        List prevSheets = this.listAllSheets(spreadsheetId);
        Collection allUniquePaths = this.expandsToUniquePaths(patternPaths);
        boolean pathsOk = this.checkPathsExist(allUniquePaths);
        if (!pathsOk) {
            throw new IllegalArgumentException("Please fix the message file paths in the configuration file.");
        }
        ExportResult result = this.translationCollector.walkPathsAndCollectTranslationSheets(allUniquePaths, translationLangs);
        this.uploadTranslations(result, spreadsheetId, lockedCellEditors);
        this.updateSnapshotAndWriteToDisk(this.snapshot, result, snapshotPath);
        List prevSheetIds = prevSheets.stream().map(ASheet::getId).collect(Collectors.toList());
        this.deleteOldSheets(prevSheetIds, spreadsheetId);
    }

    private void warnDuplicatePaths(List<String> patternPaths) {
        List duplicatePaths = this.detectDuplicatePatternPaths(patternPaths);
        if (!duplicatePaths.isEmpty()) {
            log.warn((Object)"Detected duplicate message file paths in configuration file:");
            duplicatePaths.forEach(dup -> log.warn((Object)("'" + dup + "' is defined more than once.")));
        }
    }

    private List<String> detectDuplicatePatternPaths(List<String> patternPaths) {
        return patternPaths.stream().collect(Collectors.groupingBy(Function.identity())).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private Collection<String> expandsToUniquePaths(List<String> patternPaths) {
        return patternPaths.stream().map(arg_0 -> this.expandPath(arg_0)).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private List<String> expandPath(String patternPath) {
        try {
            return this.pu.expandPath(patternPath, this.resourceLoader);
        }
        catch (IOException e) {
            throw new RuntimeException("Error when expanding path '" + patternPath + "'", e);
        }
    }

    private boolean checkPathsExist(Collection<String> paths) {
        boolean pathsOk = true;
        for (String path : paths) {
            if (new File(path).exists()) continue;
            log.error((Object)("File '" + path + "' could not be found."));
            pathsOk = false;
        }
        return pathsOk;
    }

    private List<ASheet> listAllSheets(String spreadsheetId) {
        try {
            return this.gsc.listSheets(spreadsheetId);
        }
        catch (SheetsException e) {
            String errMsg = "Error when listing sheets of spreadsheet '" + spreadsheetId + "'";
            throw new RuntimeException(errMsg, e);
        }
    }

    private void uploadTranslations(ExportResult exportResult, String spreadsheetId, List<String> lockedCellEditors) {
        exportResult.getSheets().stream().filter(sheet -> !sheet.getDataRows().isEmpty()).forEach(sheet -> {
            try {
                log.info((Object)("Writing " + sheet.getDataRows().size() + " rows into sheet '" + sheet.getSheetName() + "'."));
                this.gsc.createSheet(spreadsheetId, sheet.getSheetName(), sheet.getRows(), lockedCellEditors);
            }
            catch (SheetsException e) {
                String errMsg = "Error when uploading data to spreadsheet '" + spreadsheetId + "'";
                throw new RuntimeException(errMsg, e);
            }
        });
    }

    private void updateSnapshotAndWriteToDisk(TranslationSnapshotWriteContract snapshot, ExportResult exportResult, Path snapshotFile) {
        try {
            Iterable newMsgFiles = exportResult.getPathsOfNewMsgFiles();
            newMsgFiles.forEach(arg_0 -> ((TranslationSnapshotWriteContract)snapshot).registerMsgFile(arg_0));
            File snapshotFileName = snapshotFile.toFile();
            SnapshotUtils.writeSnapshot((Snapshot)snapshot.getUnderlyingSnapshot(), (File)snapshotFileName);
        }
        catch (IOException e) {
            String errMsg = "Error when updating translation snapshot '" + snapshotFile + "' with new message file paths.";
            throw new RuntimeException(errMsg, e);
        }
    }

    private void deleteOldSheets(Collection<Integer> sheetIds, String spreadsheetId) {
        try {
            this.gsc.deleteSheets(spreadsheetId, sheetIds);
        }
        catch (SheetsException e) {
            String errMsg = "Error when deleting sheets '" + sheetIds + "'";
            throw new RuntimeException(errMsg, e);
        }
    }
}

