/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import one.edee.babylon.properties.PropertyFileActiveRecord;

public class PropertyFileLoader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PropertyFileActiveRecord loadPropertiesFromFile(String fileNamePath) {
        if (!new File(fileNamePath).exists()) {
            return null;
        }
        try (FileInputStream propertyFile = new FileInputStream(fileNamePath);){
            PropertyFileActiveRecord propertyFileActiveRecord = this.loadProperties(propertyFile);
            return propertyFileActiveRecord;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not close file " + fileNamePath, e);
        }
    }

    public PropertyFileActiveRecord loadProperties(InputStream propertyFile) throws IOException {
        PropertyFileActiveRecord propertyFileActiveRecord = new PropertyFileActiveRecord();
        try (InputStreamReader inputStreamReader = new InputStreamReader(propertyFile, StandardCharsets.UTF_8);){
            propertyFileActiveRecord.load(inputStreamReader);
        }
        return propertyFileActiveRecord;
    }
}

