/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon;

import java.io.IOException;
import java.security.GeneralSecurityException;
import one.edee.babylon.config.TranslationConfiguration;
import one.edee.babylon.enums.Action;
import one.edee.babylon.export.Exporter;
import one.edee.babylon.imp0rt.ImportProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MainService {
    private static final Log log = LogFactory.getLog(MainService.class);
    private final ImportProcessor importProcessor;
    private final Exporter exporter;

    @Autowired
    public MainService(Exporter exporter, ImportProcessor importProcessor) {
        this.exporter = exporter;
        this.importProcessor = importProcessor;
    }

    public void startTranslation(Action action, TranslationConfiguration configuration, String spreadsheetId) throws IOException, GeneralSecurityException, InterruptedException {
        long stTime = System.currentTimeMillis();
        switch (action) {
            case EXPORT: {
                log.info((Object)"Babylon starting...");
                this.exporter.walkPathsAndWriteSheets(configuration.getPath(), configuration.getMutations(), spreadsheetId, configuration.getSnapshotPath(), configuration.getLockedCellEditor());
                break;
            }
            case IMPORT: {
                this.importProcessor.doImport(spreadsheetId);
            }
        }
        log.info((Object)("Translation done in: " + (System.currentTimeMillis() - stTime) + "ms"));
    }
}

