/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.imp0rt;

import com.google.api.services.sheets.v4.model.Sheet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import one.edee.babylon.config.TranslationConfiguration;
import one.edee.babylon.db.SnapshotManager;
import one.edee.babylon.db.SnapshotUtils;
import one.edee.babylon.entity.MessageFileContent;
import one.edee.babylon.entity.PropertiesMap;
import one.edee.babylon.enums.Action;
import one.edee.babylon.git.GitAdd;
import one.edee.babylon.git.RuntimeExecGitAdd;
import one.edee.babylon.imp0rt.ImportSheetProcessor;
import one.edee.babylon.msgfile.TranslationFileUtils;
import one.edee.babylon.properties.Property;
import one.edee.babylon.properties.PropertyFileActiveRecord;
import one.edee.babylon.properties.PropertyFileLoader;
import one.edee.babylon.sheets.gsheets.LightGSheetService;
import one.edee.babylon.snapshot.Snapshot;
import one.edee.babylon.statistics.ImportFileStatistic;
import one.edee.babylon.statistics.TranslationStatisticsOfImport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportProcessor {
    private static final Log log = LogFactory.getLog(ImportProcessor.class);
    private final SnapshotManager snapshotManager;
    private final PropertyFileLoader propertyFileLoader;
    private final LightGSheetService lightGSheetService;
    private final TranslationConfiguration configuration;
    private final GitAdd gitAdd;
    private final ImportSheetProcessor importSheetProcessor;

    public ImportProcessor(LightGSheetService lightGSheetService, SnapshotManager snapshotManager, PropertyFileLoader propertyFileLoader, TranslationConfiguration configuration) {
        this.snapshotManager = snapshotManager;
        this.propertyFileLoader = propertyFileLoader;
        this.lightGSheetService = lightGSheetService;
        this.configuration = configuration;
        this.gitAdd = new RuntimeExecGitAdd();
        this.importSheetProcessor = new ImportSheetProcessor();
    }

    public void doImport(String googleSheetId) throws IOException, GeneralSecurityException, InterruptedException {
        log.info((Object)("Started translation IMPORT with Google sheet id: '" + googleSheetId + "'"));
        TranslationStatisticsOfImport statistics = new TranslationStatisticsOfImport();
        statistics.setAction(Action.IMPORT);
        Snapshot snapshot = this.snapshotManager.getOrCreateDataFile();
        List<Sheet> sheets = this.lightGSheetService.listSheetsEagerly(googleSheetId);
        if (sheets == null || sheets.isEmpty()) {
            throw new IllegalArgumentException("Source spreadsheet " + googleSheetId + " not contains any sheets.");
        }
        for (Sheet sheet : sheets) {
            this.importSheetProcessor.processSheet(sheet, snapshot);
        }
        Map<String, MessageFileContent> dataPropFiles = this.snapshotManager.getOrCreateDataFile().getDataPropFiles();
        this.saveTranslations(statistics, this.configuration.getMutations(), dataPropFiles);
        this.saveDataFile(snapshot, this.configuration.getDataFileName());
        log.info((Object)statistics);
    }

    private void saveDataFile(Snapshot snapshot, String dbFileName) throws IOException {
        if (snapshot.getDataPropFiles().isEmpty()) {
            throw new IllegalArgumentException("Cannot save empty DataFile object to file \"" + dbFileName + "\"");
        }
        File toFile = new File(dbFileName);
        SnapshotUtils.writeSnapshot(snapshot, toFile);
    }

    private void saveTranslations(TranslationStatisticsOfImport statistics, List<String> translationLangs, Map<String, MessageFileContent> dataPropFiles) throws IOException, InterruptedException {
        for (Map.Entry<String, MessageFileContent> entry : dataPropFiles.entrySet()) {
            String primaryPropFilePath = entry.getKey();
            MessageFileContent messageFileContent = entry.getValue();
            for (String mutation : translationLangs) {
                this.saveMutationPropertiesToFile(primaryPropFilePath, mutation, messageFileContent, statistics);
            }
        }
    }

    private void saveMutationPropertiesToFile(String primaryPropFilePath, String mutation, MessageFileContent messageFileContent, TranslationStatisticsOfImport statistics) throws IOException, InterruptedException {
        PropertiesMap mutationProperties = messageFileContent.getMutationProperties(mutation);
        String mutationPropFilePath = TranslationFileUtils.getFileNameForTranslation(primaryPropFilePath, mutation);
        if (mutationProperties == null || mutationProperties.isEmpty()) {
            String msg = "No properties found in source google sheet for import data into \"" + mutationPropFilePath + "\"";
            log.info((Object)msg);
            return;
        }
        log.info((Object)("Saving translations into \"" + mutationPropFilePath + "\"..."));
        ImportFileStatistic fs = statistics.getFileStatistic(mutationPropFilePath);
        if (fs == null) {
            fs = new ImportFileStatistic();
            statistics.putFileStatistic(mutationPropFilePath, fs);
        }
        ImportFileStatistic fileStatistic = fs;
        PropertyFileActiveRecord originalMutationFileProps = Optional.ofNullable(this.propertyFileLoader.loadPropertiesFromFile(mutationPropFilePath)).orElse(new PropertyFileActiveRecord());
        PropertyFileActiveRecord updatedFileProps = this.propertyFileLoader.loadPropertiesFromFile(primaryPropFilePath);
        updatedFileProps.values().forEach(property -> {
            if (property.isPropValue() || property.isPropValueMultiLine()) {
                property.setValue("");
            }
        });
        PropertyFileActiveRecord propsOnlyInMutation = new PropertyFileActiveRecord();
        originalMutationFileProps.forEach((key, sourceProp) -> {
            if (!sourceProp.isPropValue() && !sourceProp.isPropValueMultiLine()) {
                return;
            }
            Property targetProp = (Property)updatedFileProps.get(key);
            if (targetProp != null) {
                targetProp.setValue(sourceProp.getValue());
            } else {
                propsOnlyInMutation.put(key, sourceProp);
            }
        });
        mutationProperties.forEach((key, value) -> {
            Property property = (Property)updatedFileProps.get(key);
            if (property != null && !Objects.equals(value, property.getValue())) {
                property.setValue((String)value);
                updatedFileProps.put(key, property);
                fileStatistic.incUpdatedCnt();
                statistics.incTotalUpdatedCnt();
            }
        });
        if (!propsOnlyInMutation.isEmpty()) {
            fileStatistic.setNotFoundInPrimaryFile(propsOnlyInMutation.size());
            statistics.incTotalNotFoundInPrimaryFile(propsOnlyInMutation.size());
            propsOnlyInMutation.forEach(updatedFileProps::put);
            log.info((Object)("Property keys only in mutation file \"" + String.join((CharSequence)",", propsOnlyInMutation.keySet()) + "\""));
        }
        PropertiesMap primaryProperties = messageFileContent.getProperties();
        List<String> propsToRemove = updatedFileProps.entrySet().stream().filter(k -> ((Property)k.getValue()).getValue().equals("") && !primaryProperties.containsKey(k.getKey())).map(Map.Entry::getKey).collect(Collectors.toList());
        propsToRemove.forEach(updatedFileProps::remove);
        this.savePropertiesToFile(updatedFileProps, mutationPropFilePath);
    }

    private void savePropertiesToFile(PropertyFileActiveRecord propertyFileActiveRecord, String pathFileName) {
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(pathFileName), StandardCharsets.UTF_8);){
            propertyFileActiveRecord.save(outputStreamWriter);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not close the file " + pathFileName, e);
        }
        this.gitAdd.gitAddFile(pathFileName);
    }
}

