/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.entity;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import one.edee.babylon.entity.PropertiesMap;
import one.edee.babylon.enums.PropertyStatus;

@JsonFilter(value="MessageFileFilter")
public class MessageFileContent
implements Serializable {
    private static final long serialVersionUID = 2426359297082283380L;
    private Integer id;
    private PropertiesMap properties = new PropertiesMap();
    @JsonIgnore
    private Map<String, PropertiesMap> mutationProperties = new LinkedHashMap<String, PropertiesMap>();

    public String putProperty(String key, String value) {
        String result = this.properties.put(key, value);
        if (result == null) {
            this.putPropertyStatus(key, PropertyStatus.NEW);
        } else if (!result.equals(value)) {
            this.putPropertyStatus(key, PropertyStatus.CHANGED);
        } else {
            this.putPropertyStatus(key, PropertyStatus.UNCHANGED);
        }
        return result;
    }

    public String putProperty(String key, String value, PropertyStatus propertyStatus) {
        return this.properties.put(key, value, propertyStatus);
    }

    public String putMutationProperty(String mutation, String key, String value) {
        PropertiesMap propertiesMap = this.mutationProperties.get(mutation);
        if (propertiesMap == null) {
            propertiesMap = new PropertiesMap();
            this.mutationProperties.put(mutation, propertiesMap);
        }
        return propertiesMap.put(key, value);
    }

    public String getPropertyValue(String propertyKey) {
        return (String)this.properties.get(propertyKey);
    }

    public PropertyStatus putPropertyStatus(String key, PropertyStatus propertyStatus) {
        return this.properties.putPropertyStatus(key, propertyStatus);
    }

    public PropertyStatus getPropertyStatus(String key) {
        return this.properties.getPropertyStatus(key);
    }

    public PropertiesMap putMutationProperties(String mutation, PropertiesMap properties) {
        return this.mutationProperties.put(mutation, properties);
    }

    public PropertiesMap getMutationProperties(String mutation) {
        return this.mutationProperties.get(mutation);
    }

    public Integer getId() {
        return this.id;
    }

    public PropertiesMap getProperties() {
        return this.properties;
    }

    public Map<String, PropertiesMap> getMutationProperties() {
        return this.mutationProperties;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setProperties(PropertiesMap properties) {
        this.properties = properties;
    }

    @JsonIgnore
    public void setMutationProperties(Map<String, PropertiesMap> mutationProperties) {
        this.mutationProperties = mutationProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageFileContent)) {
            return false;
        }
        MessageFileContent other = (MessageFileContent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        PropertiesMap this$properties = this.getProperties();
        PropertiesMap other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        Map<String, PropertiesMap> this$mutationProperties = this.getMutationProperties();
        Map<String, PropertiesMap> other$mutationProperties = other.getMutationProperties();
        return !(this$mutationProperties == null ? other$mutationProperties != null : !((Object)this$mutationProperties).equals(other$mutationProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageFileContent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        PropertiesMap $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        Map<String, PropertiesMap> $mutationProperties = this.getMutationProperties();
        result = result * 59 + ($mutationProperties == null ? 43 : ((Object)$mutationProperties).hashCode());
        return result;
    }

    public String toString() {
        return "MessageFileContent(id=" + this.getId() + ", properties=" + this.getProperties() + ", mutationProperties=" + this.getMutationProperties() + ")";
    }
}

