/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.export;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.edee.babylon.config.SupportedTranslators;
import one.edee.babylon.config.TranslationConfiguration;
import one.edee.babylon.db.SnapshotUtils;
import one.edee.babylon.export.Exporter;
import one.edee.babylon.export.TranslationCollector;
import one.edee.babylon.export.dto.ExportResult;
import one.edee.babylon.export.dto.TranslationSheet;
import one.edee.babylon.export.translator.Translator;
import one.edee.babylon.sheets.SheetsException;
import one.edee.babylon.sheets.gsheets.model.ASheet;
import one.edee.babylon.snapshot.Snapshot;
import one.edee.babylon.snapshot.TranslationSnapshotWriteContract;
import one.edee.babylon.util.AntPathResourceLoader;
import one.edee.babylon.util.PathUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Exporter {
    private static final Log log = LogFactory.getLog(Exporter.class);
    private static final String COMBINING_SHEET_NAME = "ALL";
    private final ApplicationContext applicationContext;
    private final TranslationCollector translationCollector;
    private final TranslationSnapshotWriteContract snapshot;
    private final SheetContract gsc;
    private final AntPathResourceLoader resourceLoader;
    private final PathUtils pu = new PathUtils();

    public void walkPathsAndWriteSheets(TranslationConfiguration configuration, String spreadsheetId, boolean combineSheets) {
        List patternPaths = configuration.getPath();
        this.warnDuplicatePaths(patternPaths);
        List prevSheets = this.listAllSheets(spreadsheetId);
        Collection allUniquePaths = this.expandsToUniquePaths(patternPaths);
        boolean pathsOk = this.checkPathsExist(allUniquePaths);
        if (!pathsOk) {
            throw new IllegalArgumentException("Please fix the message file paths in the configuration file.");
        }
        ExportResult result = this.translationCollector.walkPathsAndCollectTranslationSheets(allUniquePaths, configuration.getMutations());
        if (combineSheets) {
            List original = result.getSheets();
            ArrayList sheets = new ArrayList(original);
            original.clear();
            LinkedList combine = new LinkedList();
            for (int i = 0; i < sheets.size(); ++i) {
                TranslationSheet sheet = (TranslationSheet)sheets.get(i);
                List rows = sheet.getRows();
                if (i != 0) {
                    rows.remove(0);
                }
                combine.addAll(rows);
            }
            original.add(new TranslationSheet(COMBINING_SHEET_NAME, combine));
        }
        Map changed = this.translateTextsByExternalTool(configuration, result);
        this.uploadTranslations(result, spreadsheetId, configuration.getLockedCellEditors(), changed);
        this.updateSnapshotAndWriteToDisk(this.snapshot, result, configuration.getSnapshotPath());
        List prevSheetIds = prevSheets.stream().map(ASheet::getId).collect(Collectors.toList());
        this.deleteOldSheets(prevSheetIds, spreadsheetId);
    }

    @NotNull
    private Map<String, List<String>> translateTextsByExternalTool(TranslationConfiguration configuration, ExportResult result) {
        HashMap<String, List<String>> changed = new HashMap<String, List<String>>();
        if (configuration.getTranslatorApiKey() != null) {
            SupportedTranslators translatorType = Optional.ofNullable(configuration.getTranslator()).orElse(SupportedTranslators.GOOGLE);
            Translator translator = this.applicationContext.getBeansOfType(Translator.class).values().stream().filter(i -> i.getSupportedTranslator().equals((Object)translatorType)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find translator bean for type" + translatorType));
            translator.init(configuration.getTranslatorApiKey());
            try {
                for (TranslationSheet sheet : result.getSheets()) {
                    List rows = sheet.getRows();
                    if (rows.size() == 1) continue;
                    log.info((Object)("Translating sheet " + sheet.getSheetName()));
                    List header = (List)rows.get(0);
                    List originals = rows.stream().map(i -> (String)i.get(1)).map(i -> StringUtils.hasText((String)i) ? i : "____DUMMY").collect(Collectors.toList());
                    HashMap<String, List> translations = new HashMap<String, List>();
                    for (String lang : header.stream().skip(2L).collect(Collectors.toList())) {
                        translations.put(lang, translator.translate(configuration.getDefaultLang(), originals, lang));
                    }
                    for (int i2 = 1; i2 < rows.size(); ++i2) {
                        HashMap<Integer, String> toChange = new HashMap<Integer, String>();
                        List cells = (List)rows.get(i2);
                        String original = (String)cells.get(1);
                        for (int l = 2; l < cells.size(); ++l) {
                            if (!StringUtils.isEmpty(cells.get(l))) continue;
                            String lang = (String)header.get(l);
                            if (!StringUtils.hasText((String)original)) continue;
                            String transOriginal = (String)originals.get(i2);
                            if (Objects.equals(original, "____DUMMY")) continue;
                            Assert.isTrue((boolean)Objects.equals(transOriginal, original), (String)"Originals does not equals!");
                            String translatedText = (String)((List)translations.get(lang)).get(i2);
                            toChange.put(l, translatedText);
                            changed.computeIfAbsent(sheet.getSheetName(), key -> new LinkedList()).add(i2 + "_" + l);
                        }
                        for (Map.Entry entry : toChange.entrySet()) {
                            cells.remove((Integer)entry.getKey());
                            cells.add((Integer)entry.getKey(), (String)entry.getValue());
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return changed;
    }

    private void warnDuplicatePaths(List<String> patternPaths) {
        List duplicatePaths = this.detectDuplicatePatternPaths(patternPaths);
        if (!duplicatePaths.isEmpty()) {
            log.warn((Object)"Detected duplicate message file paths in configuration file:");
            duplicatePaths.forEach(dup -> log.warn((Object)("'" + dup + "' is defined more than once.")));
        }
    }

    private List<String> detectDuplicatePatternPaths(List<String> patternPaths) {
        return patternPaths.stream().collect(Collectors.groupingBy(Function.identity())).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private Collection<String> expandsToUniquePaths(List<String> patternPaths) {
        return patternPaths.stream().map(arg_0 -> this.expandPath(arg_0)).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private List<String> expandPath(String patternPath) {
        try {
            return this.pu.expandPath(patternPath, this.resourceLoader);
        }
        catch (IOException e) {
            throw new RuntimeException("Error when expanding path '" + patternPath + "'", e);
        }
    }

    private boolean checkPathsExist(Collection<String> paths) {
        boolean pathsOk = true;
        for (String path : paths) {
            if (new File(path).exists()) continue;
            log.error((Object)("File '" + path + "' could not be found."));
            pathsOk = false;
        }
        return pathsOk;
    }

    private List<ASheet> listAllSheets(String spreadsheetId) {
        try {
            return this.gsc.listSheets(spreadsheetId);
        }
        catch (SheetsException e) {
            String errMsg = "Error when listing sheets of spreadsheet '" + spreadsheetId + "'";
            throw new RuntimeException(errMsg, e);
        }
    }

    private void uploadTranslations(ExportResult exportResult, String spreadsheetId, List<String> lockedCellEditors, Map<String, List<String>> changed) {
        exportResult.getSheets().stream().filter(sheet -> !sheet.getDataRows().isEmpty()).forEach(sheet -> {
            try {
                log.info((Object)("Writing " + sheet.getDataRows().size() + " rows into sheet '" + sheet.getSheetName() + "'."));
                this.gsc.createSheet(spreadsheetId, sheet.getSheetName(), sheet.getRows(), lockedCellEditors, changed);
            }
            catch (SheetsException e) {
                String errMsg = "Error when uploading data to spreadsheet '" + spreadsheetId + "'";
                throw new RuntimeException(errMsg, e);
            }
        });
    }

    private void updateSnapshotAndWriteToDisk(TranslationSnapshotWriteContract snapshot, ExportResult exportResult, Path snapshotFile) {
        try {
            Iterable newMsgFiles = exportResult.getPathsOfNewMsgFiles();
            newMsgFiles.forEach(arg_0 -> ((TranslationSnapshotWriteContract)snapshot).registerMsgFile(arg_0));
            File snapshotFileName = snapshotFile.toFile();
            SnapshotUtils.writeSnapshot((Snapshot)snapshot.getUnderlyingSnapshot(), (File)snapshotFileName);
        }
        catch (IOException e) {
            String errMsg = "Error when updating translation snapshot '" + snapshotFile + "' with new message file paths.";
            throw new RuntimeException(errMsg, e);
        }
    }

    private void deleteOldSheets(Collection<Integer> sheetIds, String spreadsheetId) {
        try {
            this.gsc.deleteSheets(spreadsheetId, sheetIds);
        }
        catch (SheetsException e) {
            String errMsg = "Error when deleting sheets '" + sheetIds + "'";
            throw new RuntimeException(errMsg, e);
        }
    }

    public Exporter(ApplicationContext applicationContext, TranslationCollector translationCollector, TranslationSnapshotWriteContract snapshot, SheetContract gsc, AntPathResourceLoader resourceLoader) {
        this.applicationContext = applicationContext;
        this.translationCollector = translationCollector;
        this.snapshot = snapshot;
        this.gsc = gsc;
        this.resourceLoader = resourceLoader;
    }
}

