/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import one.edee.babylon.export.MessageFileProcessor;
import one.edee.babylon.export.MessageLoader;
import one.edee.babylon.export.dto.ExportResult;
import one.edee.babylon.export.dto.MessageFileExportResult;
import one.edee.babylon.export.dto.TranslationSheet;
import one.edee.babylon.export.stats.MessageFileExportStats;
import one.edee.babylon.sheets.SheetUtils;
import one.edee.babylon.snapshot.TranslationSnapshotReadContract;
import one.edee.babylon.snapshot.TranslationSnapshotWriteContract;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class TranslationCollector {
    private static final Log log = LogFactory.getLog(TranslationCollector.class);
    private final List<MessageLoader> messageLoaders;
    private final MessageFileProcessor messageFileProcessor;
    private final TranslationSnapshotReadContract snapshotReadContract;
    private final TranslationSnapshotWriteContract snapshotWriteContract;

    public ExportResult walkPathsAndCollectTranslationSheets(Collection<String> allPaths, List<String> translateTo) {
        List newMsgFilesPaths = allPaths.stream().filter(msgFilePath -> !this.snapshotReadContract.includesMsgFile(msgFilePath)).collect(Collectors.toList());
        List sheetsAndStats = allPaths.stream().map(msgFilePath -> this.processMsgFile(msgFilePath, translateTo)).collect(Collectors.toList());
        List sheets = this.getSheets(sheetsAndStats);
        List exportStats = this.getStats(sheetsAndStats);
        this.logMsgFileStats((Iterable)exportStats);
        List obsoleteFilePaths = this.snapshotReadContract.listMsgFiles().stream().filter(msgFilePath -> !allPaths.contains(msgFilePath)).collect(Collectors.toList());
        this.snapshotWriteContract.removeMsgFilePaths(obsoleteFilePaths);
        return new ExportResult(newMsgFilesPaths, sheets);
    }

    private List<TranslationSheet> getSheets(List<MessageFileExportResult> sheetsAndStats) {
        return sheetsAndStats.stream().map(MessageFileExportResult::getTranslationSheet).collect(Collectors.toList());
    }

    private List<MessageFileExportStats> getStats(List<MessageFileExportResult> sheetsAndStats) {
        return sheetsAndStats.stream().map(MessageFileExportResult::getExportStats).collect(Collectors.toList());
    }

    private MessageFileExportResult processMsgFile(String msgFilePath, List<String> translateTo) {
        MessageFileProcessor.Pair msgFileResult = this.computeTranslationSheetRows(msgFilePath, translateTo);
        MessageFileProcessor.SheetContent sheetData = (MessageFileProcessor.SheetContent)msgFileResult.getFirst();
        MessageFileExportStats msgFileStats = (MessageFileExportStats)msgFileResult.getSecond();
        Integer sheetId = this.snapshotWriteContract.registerMsgFile(msgFilePath);
        TranslationSheet translationSheet = this.newTranslationSheet(sheetData, sheetId, msgFilePath, translateTo);
        return new MessageFileExportResult(translationSheet, msgFileStats);
    }

    private MessageFileProcessor.Pair<MessageFileProcessor.SheetContent, MessageFileExportStats> computeTranslationSheetRows(String msgFilePath, List<String> translateTo) {
        Map primaryMsgs = null;
        Map translations = null;
        for (MessageLoader messageLoader : this.messageLoaders) {
            if (!messageLoader.canBeLoaded(msgFilePath)) continue;
            primaryMsgs = messageLoader.loadPrimaryMessages(msgFilePath);
            translations = messageLoader.loadTranslations(msgFilePath, translateTo);
        }
        Assert.notNull(primaryMsgs, (String)("There is no appropriate message loader for file path  with extension: " + msgFilePath));
        Assert.notNull((Object)translations, (String)("There is no appropriate message loader for file path  with extension: " + msgFilePath));
        return this.messageFileProcessor.prepareTranslationSheet(msgFilePath, primaryMsgs, translations, translateTo);
    }

    private TranslationSheet newTranslationSheet(MessageFileProcessor.SheetContent sheetContent, Integer sheetId, String msgFilePath, List<String> translateTo) {
        String sheetName = new SheetUtils().getSheetName(msgFilePath, sheetId);
        ArrayList<List> allRows = new ArrayList<List>();
        allRows.add(sheetContent.getHeader());
        allRows.addAll(sheetContent.getDataRows());
        return new TranslationSheet(sheetName, allRows);
    }

    private void logMsgFileStats(Iterable<MessageFileExportStats> exportStats) {
        exportStats.forEach(arg_0 -> this.logMsgFileStats(arg_0));
    }

    private void logMsgFileStats(MessageFileExportStats msgFileStats) {
        String msg = msgFileStats.getMessageFilePath() + ": \n\t" + msgFileStats.getNewPrimaryMsgKeyCount() + " new messages, \n\t" + msgFileStats.getChangedPrimaryMsgKeyCount() + " messages with changed values in primary language, \n\t" + msgFileStats.getMissingTranslationMsgKeyCount() + " messages with some translations missing.\n\t" + msgFileStats.getSheetDataRows() + " total rows in translation sheet.";
        log.info((Object)msg);
    }

    public TranslationCollector(List<MessageLoader> messageLoaders, MessageFileProcessor messageFileProcessor, TranslationSnapshotReadContract snapshotReadContract, TranslationSnapshotWriteContract snapshotWriteContract) {
        this.messageLoaders = messageLoaders;
        this.messageFileProcessor = messageFileProcessor;
        this.snapshotReadContract = snapshotReadContract;
        this.snapshotWriteContract = snapshotWriteContract;
    }
}

