/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.export.translator;

import com.theokanning.openai.OpenAiHttpException;
import com.theokanning.openai.completion.chat.ChatCompletionChoice;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatCompletionResult;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.service.OpenAiService;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import one.edee.babylon.config.SupportedTranslators;
import one.edee.babylon.export.translator.Translator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class OpenAiTranslator
implements Translator {
    private static final Logger log = LogManager.getLogger(OpenAiTranslator.class);
    OpenAiService service = null;

    public void init(@NotNull String apiKey) {
        this.service = new OpenAiService(apiKey, Duration.ofSeconds(60L));
    }

    public List<String> translate(@Nullable String defaultLang, @NotNull List<String> original, @NotNull String lang) {
        List<String> output;
        Assert.notNull((Object)this.service, (String)"Init method with api key has to be called before translation!");
        String systemMessage = System.getProperty("babylon.openai.systemMessage");
        String formattedSystemMessage = String.format(Optional.ofNullable(systemMessage).orElse("You are translator that translate eshop messages from %s to %s. If you cannot translate it, return original text. Texts to translate are combined by '~'. Split input by comma, translate and return in same format."), defaultLang, lang);
        String joined = String.join((CharSequence)"~", original);
        List<ChatMessage> messages = Arrays.asList(new ChatMessage("system", formattedSystemMessage), new ChatMessage("user", joined));
        int tries = 5;
        do {
            String result;
            if ((output = Arrays.stream((result = this.translateInner(messages, original)).split("~")).collect(Collectors.toList())).size() == original.size()) continue;
            log.warn("Size not equal " + joined + " " + result);
        } while (--tries > 0 && output.size() != original.size());
        if (output.size() != original.size()) {
            throw new IllegalArgumentException("Size not equal, even after 5 tries!");
        }
        return output;
    }

    private String translateInner(List<ChatMessage> messages, @NotNull List<String> original) throws InterruptedException {
        ChatCompletionResult chatCompletion;
        try {
            chatCompletion = this.service.createChatCompletion(ChatCompletionRequest.builder().model(Optional.ofNullable(System.getProperty("babylon.openai.model")).orElse("gpt-3.5-turbo-16k-0613")).messages(messages).build());
        }
        catch (OpenAiHttpException e) {
            if (e.getMessage().contains("Please try again in 20s")) {
                log.info("Rate limit reached, will try again in 20 secs! Translate in progress " + original);
                Thread.sleep(20000L);
                return this.translateInner(messages, original);
            }
            throw e;
        }
        return ((ChatCompletionChoice)chatCompletion.getChoices().get(0)).getMessage().getContent();
    }

    public SupportedTranslators getSupportedTranslator() {
        return SupportedTranslators.OPENAI;
    }
}

