/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.properties;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import one.edee.babylon.properties.FileActiveRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class FileLoader {
    private static final Logger log = LogManager.getLogger(FileLoader.class);

    public FileActiveRecord loadPropertiesFromFile(String fileNamePath) {
        FileActiveRecord fileActiveRecord;
        block9: {
            if (!new File(fileNamePath).exists()) {
                return this.createFileActiveRecord();
            }
            log.info("Loading file: " + fileNamePath);
            InputStream propertyFile = Files.newInputStream(Paths.get(fileNamePath, new String[0]), new OpenOption[0]);
            try {
                fileActiveRecord = this.loadProperties(propertyFile);
                if (propertyFile == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (propertyFile != null) {
                        try {
                            propertyFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Could not close file " + fileNamePath, e);
                }
            }
            propertyFile.close();
        }
        return fileActiveRecord;
    }

    public FileActiveRecord loadProperties(InputStream propertyFile) throws IOException {
        FileActiveRecord propertyFileActiveRecord = this.createFileActiveRecord();
        try (InputStreamReader inputStreamReader = new InputStreamReader(propertyFile, StandardCharsets.UTF_8);){
            propertyFileActiveRecord.load((Reader)inputStreamReader);
        }
        return propertyFileActiveRecord;
    }

    public abstract boolean canBeLoaded(String var1);

    public abstract FileActiveRecord createFileActiveRecord();
}

