/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.snapshot;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import one.edee.babylon.entity.MessageFileContent;

/*
 * Exception performing whole class analysis ignored.
 */
public class Snapshot
implements Serializable {
    public static final String LINUX_DELIMITER = "/";
    public static final String ORIGINAL_DELIMITER = "\\";
    private static final long serialVersionUID = 4891061639828627492L;
    @JsonProperty(value="dataPropFiles")
    private Map<String, MessageFileContent> dataPropFiles = new LinkedHashMap();
    @JsonIgnore
    private Map<Integer, MessageFileContent> dataPropFilesById = new LinkedHashMap();

    public MessageFileContent putPropFile(String fileName, MessageFileContent messageFileContent) {
        MessageFileContent propFile = this.dataPropFiles.put(Snapshot.clearPath((String)fileName), messageFileContent);
        Integer fileNameId = this.getNextUniqueId();
        messageFileContent.setId(fileNameId);
        this.putDataPropFileById(fileNameId, messageFileContent);
        return propFile;
    }

    public MessageFileContent putDataPropFileById(Integer fileNameId, MessageFileContent messageFileContent) {
        return this.dataPropFilesById.put(fileNameId, messageFileContent);
    }

    public MessageFileContent getOrPutNewPropFileByFileName(String fileName) {
        MessageFileContent messageFileContent = (MessageFileContent)this.dataPropFiles.get(fileName = Snapshot.clearPath((String)fileName));
        if (messageFileContent == null) {
            messageFileContent = new MessageFileContent();
            this.putPropFile(fileName, messageFileContent);
        }
        return messageFileContent;
    }

    public MessageFileContent getPropFileByFileName(String fileName) {
        return (MessageFileContent)this.dataPropFiles.get(Snapshot.clearPath((String)fileName));
    }

    public MessageFileContent getPropFileById(Integer id) {
        return (MessageFileContent)this.dataPropFilesById.get(id);
    }

    public void removePaths(Collection<String> msgFilePaths) {
        msgFilePaths.forEach(path -> this.dataPropFiles.remove(Snapshot.clearPath((String)path)));
    }

    @JsonIgnore
    public Collection<String> getPaths() {
        return this.dataPropFiles.keySet().stream().map(Snapshot::normalizePath).collect(Collectors.toList());
    }

    @JsonIgnore
    public Map<String, MessageFileContent> getProps() {
        return this.dataPropFiles.entrySet().stream().collect(Collectors.toMap(i -> Snapshot.normalizePath((String)((String)i.getKey())), Map.Entry::getValue));
    }

    private Integer getNextUniqueId() {
        Set ids = this.dataPropFilesById.keySet();
        if (ids.isEmpty()) {
            return 0;
        }
        Optional maxId = ids.stream().reduce(Integer::max);
        return (Integer)maxId.get() + 1;
    }

    private static String clearPath(String fileName) {
        if (File.separator.equals("/")) {
            fileName = fileName.replace("/", "\\");
        }
        return fileName;
    }

    private static String normalizePath(String fileName) {
        if (File.separator.equals("/")) {
            fileName = fileName.replace("\\", "/");
        }
        return fileName;
    }

    private Map<String, MessageFileContent> getDataPropFiles() {
        return this.dataPropFiles;
    }

    @JsonProperty(value="dataPropFiles")
    private void setDataPropFiles(Map<String, MessageFileContent> dataPropFiles) {
        this.dataPropFiles = dataPropFiles;
    }
}

