/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.snapshot;

import java.util.Collection;
import java.util.NoSuchElementException;
import one.edee.babylon.entity.MessageFileContent;
import one.edee.babylon.snapshot.Snapshot;
import one.edee.babylon.snapshot.TranslationSnapshotReadContract;
import one.edee.babylon.snapshot.TranslationSnapshotWriteContract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnapshotAdapter
implements TranslationSnapshotReadContract,
TranslationSnapshotWriteContract {
    private final Snapshot snapshot;

    public SnapshotAdapter(Snapshot snapshot) {
        this.snapshot = snapshot;
    }

    public Snapshot getUnderlyingSnapshot() {
        return this.snapshot;
    }

    public boolean includesMsgFile(String msgFile) {
        return this.snapshot.getPropFileByFileName(msgFile) != null;
    }

    public Collection<String> listMsgFiles() {
        return this.snapshot.getPaths();
    }

    public Integer registerMsgFile(String msgFilePath) {
        MessageFileContent messageFileContent = this.snapshot.getOrPutNewPropFileByFileName(msgFilePath);
        return messageFileContent.getId();
    }

    public void removeMsgFilePaths(Collection<String> msgFilePaths) {
        this.snapshot.removePaths(msgFilePaths);
    }

    public boolean containsMessage(String msgKey, String msgFile) {
        if (!this.includesMsgFile(msgFile)) {
            return false;
        }
        if (!this.includesMsgFile(msgFile)) {
            throw new NoSuchElementException("Translation snapshot doesn't contain message file '$msgFile'.");
        }
        MessageFileContent propFileByFileName = this.snapshot.getPropFileByFileName(msgFile);
        return this.containsMessageInProps(msgKey, propFileByFileName);
    }

    private boolean containsMessageInProps(String msgKey, MessageFileContent propFileByFileName) {
        return propFileByFileName.containsKey(msgKey) && propFileByFileName.getPropertyValue(msgKey) != null && !propFileByFileName.getPropertyValue(msgKey).isEmpty();
    }

    public boolean hasSameMessage(@NotNull String msgKey, @NotNull String msgFile, @Nullable String currentMsg) {
        if (!this.includesMsgFile(msgFile)) {
            throw new NoSuchElementException("Translation snapshot doesn't contain message file '$msgFile'.");
        }
        MessageFileContent propFileByFileName = this.snapshot.getPropFileByFileName(msgFile);
        if (!this.containsMessageInProps(msgKey, propFileByFileName)) {
            String errMsg = "No message for key '" + msgKey + "' in '" + msgFile + "' message file snapshot.";
            throw new NoSuchElementException(errMsg);
        }
        return propFileByFileName.hasSameValue(msgKey, currentMsg);
    }
}

