/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.statistics;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import one.edee.babylon.statistics.StatisticsField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TranslationStatisticsBase {
    private static final Log log = LogFactory.getLog(TranslationStatisticsBase.class);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator()).append("--- TRANSLATION STATISTICS ---").append(System.lineSeparator());
        for (Field field : this.getClass().getDeclaredFields()) {
            this.buildFieldStringValue(sb, field, this);
        }
        return sb.toString();
    }

    private void buildFieldStringValue(StringBuilder sb, Field field, Object instance) {
        field.setAccessible(true);
        String name = field.getName();
        try {
            StatisticsField statisticsField;
            if (Collection.class.isAssignableFrom(field.getType())) {
                Collection collection = (Collection)field.get(instance);
                for (Object item : collection) {
                    for (Field itemField : item.getClass().getDeclaredFields()) {
                        this.buildFieldStringValue(sb, itemField, item);
                    }
                }
                return;
            }
            if (Map.class.isAssignableFrom(field.getType())) {
                Map map = (Map)field.get(instance);
                for (Object key : map.keySet()) {
                    sb.append("[").append(key.toString()).append("]").append(System.lineSeparator());
                    Object item = map.get(key);
                    for (Field itemField : item.getClass().getDeclaredFields()) {
                        this.buildFieldStringValue(sb, itemField, item);
                    }
                }
            }
            if ((statisticsField = field.getDeclaredAnnotation(StatisticsField.class)) == null) {
                return;
            }
            name = statisticsField.value();
            Object valObj = field.get(instance);
            if (name.isEmpty()) {
                sb.append(valObj.toString()).append(System.lineSeparator());
            } else {
                sb.append(name).append(" = ").append(valObj.toString()).append(System.lineSeparator());
            }
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Error while printing translation statistics value \"" + name + "\""), (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranslationStatisticsBase)) {
            return false;
        }
        TranslationStatisticsBase other = (TranslationStatisticsBase)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof TranslationStatisticsBase;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

