/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.File;
import java.io.IOException;

public class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private JsonUtils() {
    }

    public static <T> T jsonObjFromFile(File file, Class<T> valueType) throws IOException {
        return (T)OBJECT_MAPPER.readValue(file, valueType);
    }

    public static <T> T jsonObjFromString(String jsonString, Class<T> valueType) throws IOException {
        return (T)OBJECT_MAPPER.readValue(jsonString, valueType);
    }

    public static void objToJsonFile(File file, Object value, boolean formatted) throws IOException {
        if (formatted) {
            OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValue(file, value);
        } else {
            OBJECT_MAPPER.writeValue(file, value);
        }
    }

    public static void objToJsonFile(File file, Object value, boolean formatted, FilterProvider filters) throws IOException {
        if (filters == null) {
            if (formatted) {
                OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValue(file, value);
            } else {
                OBJECT_MAPPER.writeValue(file, value);
            }
        } else if (formatted) {
            OBJECT_MAPPER.writer(filters).withDefaultPrettyPrinter().writeValue(file, value);
        } else {
            OBJECT_MAPPER.writer(filters).writeValue(file, value);
        }
    }

    public static String objToJsonString(Object value, boolean formatted) throws JsonProcessingException {
        if (formatted) {
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(value);
        }
        return OBJECT_MAPPER.writeValueAsString(value);
    }

    static {
        SimpleFilterProvider filterProvider = new SimpleFilterProvider();
        filterProvider.addFilter("MessageFileFilter", SimpleBeanPropertyFilter.serializeAll());
        OBJECT_MAPPER.setFilterProvider((FilterProvider)filterProvider);
    }
}

