/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class TranslationConfiguration
implements Serializable {
    private static final long serialVersionUID = -5822894615320804365L;
    private List<String> path = new ArrayList();
    @NonNull
    private String dataFileName;
    private List<String> mutations = new ArrayList();
    private List<String> lockedCellEditors = new ArrayList();
    @NonNull
    private String defaultLang;

    @JsonIgnore
    public Path getSnapshotPath() {
        return Paths.get(this.dataFileName, new String[0]);
    }

    public void addFileToPath(String fileName) {
        this.path.add(fileName);
    }

    public List<String> getPath() {
        return this.path;
    }

    @NonNull
    public String getDataFileName() {
        return this.dataFileName;
    }

    public List<String> getMutations() {
        return this.mutations;
    }

    public List<String> getLockedCellEditors() {
        return this.lockedCellEditors;
    }

    @NonNull
    public String getDefaultLang() {
        return this.defaultLang;
    }

    public void setPath(List<String> path) {
        this.path = path;
    }

    public void setDataFileName(@NonNull String dataFileName) {
        if (dataFileName == null) {
            throw new NullPointerException("dataFileName is marked non-null but is null");
        }
        this.dataFileName = dataFileName;
    }

    public void setMutations(List<String> mutations) {
        this.mutations = mutations;
    }

    public void setLockedCellEditors(List<String> lockedCellEditors) {
        this.lockedCellEditors = lockedCellEditors;
    }

    public void setDefaultLang(@NonNull String defaultLang) {
        if (defaultLang == null) {
            throw new NullPointerException("defaultLang is marked non-null but is null");
        }
        this.defaultLang = defaultLang;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranslationConfiguration)) {
            return false;
        }
        TranslationConfiguration other = (TranslationConfiguration)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$path = this.getPath();
        List other$path = other.getPath();
        if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
            return false;
        }
        String this$dataFileName = this.getDataFileName();
        String other$dataFileName = other.getDataFileName();
        if (this$dataFileName == null ? other$dataFileName != null : !this$dataFileName.equals(other$dataFileName)) {
            return false;
        }
        List this$mutations = this.getMutations();
        List other$mutations = other.getMutations();
        if (this$mutations == null ? other$mutations != null : !((Object)this$mutations).equals(other$mutations)) {
            return false;
        }
        List this$lockedCellEditors = this.getLockedCellEditors();
        List other$lockedCellEditors = other.getLockedCellEditors();
        if (this$lockedCellEditors == null ? other$lockedCellEditors != null : !((Object)this$lockedCellEditors).equals(other$lockedCellEditors)) {
            return false;
        }
        String this$defaultLang = this.getDefaultLang();
        String other$defaultLang = other.getDefaultLang();
        return !(this$defaultLang == null ? other$defaultLang != null : !this$defaultLang.equals(other$defaultLang));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TranslationConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        String $dataFileName = this.getDataFileName();
        result = result * 59 + ($dataFileName == null ? 43 : $dataFileName.hashCode());
        List $mutations = this.getMutations();
        result = result * 59 + ($mutations == null ? 43 : ((Object)$mutations).hashCode());
        List $lockedCellEditors = this.getLockedCellEditors();
        result = result * 59 + ($lockedCellEditors == null ? 43 : ((Object)$lockedCellEditors).hashCode());
        String $defaultLang = this.getDefaultLang();
        result = result * 59 + ($defaultLang == null ? 43 : $defaultLang.hashCode());
        return result;
    }

    public String toString() {
        return "TranslationConfiguration(path=" + this.getPath() + ", dataFileName=" + this.getDataFileName() + ", mutations=" + this.getMutations() + ", lockedCellEditors=" + this.getLockedCellEditors() + ", defaultLang=" + this.getDefaultLang() + ")";
    }

    public TranslationConfiguration() {
    }

    public TranslationConfiguration(@NonNull String dataFileName, @NonNull String defaultLang) {
        if (dataFileName == null) {
            throw new NullPointerException("dataFileName is marked non-null but is null");
        }
        if (defaultLang == null) {
            throw new NullPointerException("defaultLang is marked non-null but is null");
        }
        this.dataFileName = dataFileName;
        this.defaultLang = defaultLang;
    }
}

