/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.properties;

import one.edee.babylon.enums.PropertyType;
import one.edee.babylon.properties.AbstractProperty;

public class TsAttribute
extends AbstractProperty {
    public static final String MULTI_LINE_DELIMITER = "`";
    public static final String SINGLE_LINE_DELIMITER = "'";
    private String value;

    public TsAttribute(PropertyType type, String value) {
        super(type);
        this.value = value;
    }

    public String getQuotedValue() {
        String delimiter;
        String string = delimiter = this.isPropValueMultiLine() ? MULTI_LINE_DELIMITER : SINGLE_LINE_DELIMITER;
        if (this.isPropEmptyLine()) {
            return "";
        }
        return delimiter + this.value + delimiter;
    }

    public boolean isPropValueMultiLine() {
        return this.getType() == PropertyType.MULTILINE || this.getValue().contains("\n") || this.getValue().contains("\r");
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TsAttribute)) {
            return false;
        }
        TsAttribute other = (TsAttribute)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TsAttribute;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

