/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon;

import java.util.Arrays;
import java.util.stream.Collectors;
import one.edee.babylon.MainService;
import one.edee.babylon.config.TranslationConfiguration;
import one.edee.babylon.config.TranslationConfigurationReader;
import one.edee.babylon.enums.Action;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

@SpringBootApplication
public class SpringBootConsoleApplication
implements CommandLineRunner {
    private static final Log log = LogFactory.getLog(SpringBootConsoleApplication.class);
    @Autowired
    private MainService mainService;
    private final TranslationConfigurationReader configurationReader = new TranslationConfigurationReader();

    public static void main(String[] args) {
        SpringApplication.run(SpringBootConsoleApplication.class, (String[])args);
    }

    public void run(String ... args) {
        log.info((Object)("STARTING THE BABYLON FROM DIRECTORY: " + System.getProperty("user.dir")));
        log.info((Object)"WITH ARGUMENTS: ");
        for (int i = 0; i < args.length; ++i) {
            log.info((Object)String.format("args[%d]: %s", i, args[i]));
        }
        Arguments arguments = SpringBootConsoleApplication.parseArguments(args);
        try {
            log.info((Object)("Loading config file: '" + arguments.getConfigFileName() + "'"));
            TranslationConfiguration configuration = this.configurationReader.readAndCheckConfiguration(arguments.getConfigFileName());
            this.mainService.startTranslation(arguments.getAction(), configuration, arguments.getGoogleSheetId(), arguments.isCombineSheets(), arguments.getDeeplApiKey());
        }
        catch (Exception e) {
            log.error((Object)"BABYLON ERROR: ", (Throwable)e);
            System.exit(-1);
        }
    }

    public static Arguments parseArguments(String ... args) {
        if (args.length != 3 && args.length != 4 && args.length != 5) {
            log.error((Object)"Invalid input arguments, required: ");
            SpringBootConsoleApplication.printRequiredArguments();
            System.exit(-1);
        }
        Arguments arguments = new Arguments();
        try {
            arguments.setAction(Action.valueOf(args[0].toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            String validActions = Arrays.stream(Action.values()).map(action -> "\"" + action.name() + "\"").collect(Collectors.joining(" or "));
            String msg = String.format("Unexpected value of first argument: \"%s\". Valid values is %s", args[0], validActions);
            throw new IllegalArgumentException(msg);
        }
        arguments.setConfigFileName(args[1]);
        arguments.setGoogleSheetId(args[2]);
        if (args.length > 3) {
            arguments.setCombineSheets(Boolean.parseBoolean(args[3]));
            if (args.length > 4) {
                arguments.setDeeplApiKey(args[4]);
            }
        }
        return arguments;
    }

    private static void printRequiredArguments() {
        log.info((Object)"1 - expected action (import, export)");
        log.info((Object)"2 - path to translator-config.json file");
        log.info((Object)"3 - ID of the google sheet (e.g. 1xhnBAOpy8-9KWhl8NP0ZIy6mhlgXKnKcLJwKcIeyjPc)");
        log.info((Object)"4 - arg to specify combineSheets mode");
        log.info((Object)"5 - arg to specify deepl api key");
    }

    public static class Arguments {
        private Action action;
        private String configFileName;
        private String googleSheetId;
        private boolean combineSheets = false;
        private String deeplApiKey;

        public Action getAction() {
            return this.action;
        }

        public String getConfigFileName() {
            return this.configFileName;
        }

        public String getGoogleSheetId() {
            return this.googleSheetId;
        }

        public boolean isCombineSheets() {
            return this.combineSheets;
        }

        public String getDeeplApiKey() {
            return this.deeplApiKey;
        }

        public void setAction(Action action) {
            this.action = action;
        }

        public void setConfigFileName(String configFileName) {
            this.configFileName = configFileName;
        }

        public void setGoogleSheetId(String googleSheetId) {
            this.googleSheetId = googleSheetId;
        }

        public void setCombineSheets(boolean combineSheets) {
            this.combineSheets = combineSheets;
        }

        public void setDeeplApiKey(String deeplApiKey) {
            this.deeplApiKey = deeplApiKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Arguments)) {
                return false;
            }
            Arguments other = (Arguments)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isCombineSheets() != other.isCombineSheets()) {
                return false;
            }
            Action this$action = this.getAction();
            Action other$action = other.getAction();
            if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
                return false;
            }
            String this$configFileName = this.getConfigFileName();
            String other$configFileName = other.getConfigFileName();
            if (this$configFileName == null ? other$configFileName != null : !this$configFileName.equals(other$configFileName)) {
                return false;
            }
            String this$googleSheetId = this.getGoogleSheetId();
            String other$googleSheetId = other.getGoogleSheetId();
            if (this$googleSheetId == null ? other$googleSheetId != null : !this$googleSheetId.equals(other$googleSheetId)) {
                return false;
            }
            String this$deeplApiKey = this.getDeeplApiKey();
            String other$deeplApiKey = other.getDeeplApiKey();
            return !(this$deeplApiKey == null ? other$deeplApiKey != null : !this$deeplApiKey.equals(other$deeplApiKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Arguments;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCombineSheets() ? 79 : 97);
            Action $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
            String $configFileName = this.getConfigFileName();
            result = result * 59 + ($configFileName == null ? 43 : $configFileName.hashCode());
            String $googleSheetId = this.getGoogleSheetId();
            result = result * 59 + ($googleSheetId == null ? 43 : $googleSheetId.hashCode());
            String $deeplApiKey = this.getDeeplApiKey();
            result = result * 59 + ($deeplApiKey == null ? 43 : $deeplApiKey.hashCode());
            return result;
        }

        public String toString() {
            return "SpringBootConsoleApplication.Arguments(action=" + (Object)((Object)this.getAction()) + ", configFileName=" + this.getConfigFileName() + ", googleSheetId=" + this.getGoogleSheetId() + ", combineSheets=" + this.isCombineSheets() + ", deeplApiKey=" + this.getDeeplApiKey() + ")";
        }
    }
}

