/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import one.edee.babylon.config.TranslationConfiguration;
import one.edee.babylon.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TranslationConfigurationReader {
    private static final Log log = LogFactory.getLog(TranslationConfigurationReader.class);

    public TranslationConfiguration readAndCheckConfiguration(String configFileName) throws IOException {
        File file = new File(configFileName);
        if (!file.exists()) {
            throw new FileNotFoundException("Cannot find configuration file: " + file.getAbsolutePath());
        }
        TranslationConfiguration configuration = this.readConfiguration(file);
        if (configuration.getMutations().isEmpty()) {
            throw new IllegalArgumentException("No primary mutations defined in configuration file \"" + configFileName + "\"");
        }
        return configuration;
    }

    private TranslationConfiguration readConfiguration(File file) throws IOException {
        return (TranslationConfiguration)JsonUtils.jsonObjFromFile((File)file, TranslationConfiguration.class);
    }
}

