/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class TranslationConfiguration
implements Serializable {
    private static final long serialVersionUID = -5822894615320804365L;
    private List<String> path = new ArrayList<String>();
    @NonNull
    private String dataFileName;
    private List<String> mutations = new ArrayList<String>();
    private List<String> lockedCellEditors = new ArrayList<String>();
    @NonNull
    private String defaultLang;
    @NonNull
    private String translatorApiKey;

    @JsonIgnore
    public Path getSnapshotPath() {
        return Paths.get(this.dataFileName, new String[0]);
    }

    public void addFileToPath(String fileName) {
        this.path.add(fileName);
    }

    public List<String> getPath() {
        return this.path;
    }

    @NonNull
    public String getDataFileName() {
        return this.dataFileName;
    }

    public List<String> getMutations() {
        return this.mutations;
    }

    public List<String> getLockedCellEditors() {
        return this.lockedCellEditors;
    }

    @NonNull
    public String getDefaultLang() {
        return this.defaultLang;
    }

    @NonNull
    public String getTranslatorApiKey() {
        return this.translatorApiKey;
    }

    public void setPath(List<String> path) {
        this.path = path;
    }

    public void setDataFileName(@NonNull String dataFileName) {
        if (dataFileName == null) {
            throw new NullPointerException("dataFileName is marked non-null but is null");
        }
        this.dataFileName = dataFileName;
    }

    public void setMutations(List<String> mutations) {
        this.mutations = mutations;
    }

    public void setLockedCellEditors(List<String> lockedCellEditors) {
        this.lockedCellEditors = lockedCellEditors;
    }

    public void setDefaultLang(@NonNull String defaultLang) {
        if (defaultLang == null) {
            throw new NullPointerException("defaultLang is marked non-null but is null");
        }
        this.defaultLang = defaultLang;
    }

    public void setTranslatorApiKey(@NonNull String translatorApiKey) {
        if (translatorApiKey == null) {
            throw new NullPointerException("translatorApiKey is marked non-null but is null");
        }
        this.translatorApiKey = translatorApiKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranslationConfiguration)) {
            return false;
        }
        TranslationConfiguration other = (TranslationConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$path = this.getPath();
        List<String> other$path = other.getPath();
        if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
            return false;
        }
        String this$dataFileName = this.getDataFileName();
        String other$dataFileName = other.getDataFileName();
        if (this$dataFileName == null ? other$dataFileName != null : !this$dataFileName.equals(other$dataFileName)) {
            return false;
        }
        List<String> this$mutations = this.getMutations();
        List<String> other$mutations = other.getMutations();
        if (this$mutations == null ? other$mutations != null : !((Object)this$mutations).equals(other$mutations)) {
            return false;
        }
        List<String> this$lockedCellEditors = this.getLockedCellEditors();
        List<String> other$lockedCellEditors = other.getLockedCellEditors();
        if (this$lockedCellEditors == null ? other$lockedCellEditors != null : !((Object)this$lockedCellEditors).equals(other$lockedCellEditors)) {
            return false;
        }
        String this$defaultLang = this.getDefaultLang();
        String other$defaultLang = other.getDefaultLang();
        if (this$defaultLang == null ? other$defaultLang != null : !this$defaultLang.equals(other$defaultLang)) {
            return false;
        }
        String this$translatorApiKey = this.getTranslatorApiKey();
        String other$translatorApiKey = other.getTranslatorApiKey();
        return !(this$translatorApiKey == null ? other$translatorApiKey != null : !this$translatorApiKey.equals(other$translatorApiKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TranslationConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        String $dataFileName = this.getDataFileName();
        result = result * 59 + ($dataFileName == null ? 43 : $dataFileName.hashCode());
        List<String> $mutations = this.getMutations();
        result = result * 59 + ($mutations == null ? 43 : ((Object)$mutations).hashCode());
        List<String> $lockedCellEditors = this.getLockedCellEditors();
        result = result * 59 + ($lockedCellEditors == null ? 43 : ((Object)$lockedCellEditors).hashCode());
        String $defaultLang = this.getDefaultLang();
        result = result * 59 + ($defaultLang == null ? 43 : $defaultLang.hashCode());
        String $translatorApiKey = this.getTranslatorApiKey();
        result = result * 59 + ($translatorApiKey == null ? 43 : $translatorApiKey.hashCode());
        return result;
    }

    public String toString() {
        return "TranslationConfiguration(path=" + this.getPath() + ", dataFileName=" + this.getDataFileName() + ", mutations=" + this.getMutations() + ", lockedCellEditors=" + this.getLockedCellEditors() + ", defaultLang=" + this.getDefaultLang() + ", translatorApiKey=" + this.getTranslatorApiKey() + ")";
    }

    public TranslationConfiguration() {
    }

    public TranslationConfiguration(@NonNull String dataFileName, @NonNull String defaultLang, @NonNull String translatorApiKey) {
        if (dataFileName == null) {
            throw new NullPointerException("dataFileName is marked non-null but is null");
        }
        if (defaultLang == null) {
            throw new NullPointerException("defaultLang is marked non-null but is null");
        }
        if (translatorApiKey == null) {
            throw new NullPointerException("translatorApiKey is marked non-null but is null");
        }
        this.dataFileName = dataFileName;
        this.defaultLang = defaultLang;
        this.translatorApiKey = translatorApiKey;
    }
}

