/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.properties;

import java.util.LinkedList;
import java.util.List;
import one.edee.babylon.enums.PropertyType;
import one.edee.babylon.properties.AbstractProperty;
import org.springframework.util.StringUtils;

public class Property
extends AbstractProperty {
    static final String MULTILINE_SEPARATOR = "\\";
    private String value;
    private final List<String> lines = new LinkedList<String>();

    public Property(PropertyType type, String value) {
        super(type);
        this.value = Property.clearValue(value);
    }

    void addLine(String line) {
        this.lines.add(line.replace(System.lineSeparator(), ""));
    }

    public Integer getRowCount() {
        return this.lines.size();
    }

    @Override
    public String getValue() {
        if (this.isPropValueMultiLine()) {
            return this.getMultilineValue();
        }
        if (this.isPropEmptyLine()) {
            return "";
        }
        return this.value;
    }

    @Override
    public void setValue(String value) {
        value = Property.clearValue(value);
        if (this.isPropValueMultiLine()) {
            this.setMultilineValue(value);
            return;
        }
        this.value = value;
    }

    private void setMultilineValue(String value) {
        if (StringUtils.isEmpty((Object)value)) {
            this.lines.clear();
            return;
        }
        String[] split = value.split("\\\\\r\n");
        this.lines.clear();
        for (int i = 0; i < split.length; ++i) {
            String line = split[i];
            if (i < split.length - 1 && !line.endsWith(MULTILINE_SEPARATOR)) {
                line = line + MULTILINE_SEPARATOR;
            }
            this.lines.add(line);
        }
    }

    private String getMultilineValue() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i);
            sb.append(line);
            if (i >= this.lines.size() - 1 || line.endsWith(System.lineSeparator())) continue;
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public static String clearValue(String value) {
        return value.replace("\n", "\\n");
    }
}

