/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.export;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import one.edee.babylon.export.MessageLoader;
import one.edee.babylon.export.ts.TypeScriptBabylonParserListener;
import one.edee.babylon.export.ts.gen.TypeScriptLexer;
import one.edee.babylon.export.ts.gen.TypeScriptParser;
import one.edee.babylon.msgfile.TranslationFileUtils;
import one.edee.babylon.util.FileUtils;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TsMessageLoader
implements MessageLoader {
    private static final Logger log = LogManager.getLogger(TsMessageLoader.class);
    public static final String TS_FILE_EXTENSION = ".ts";

    @Override
    public boolean canBeLoaded(String filePath) {
        return filePath.endsWith(TS_FILE_EXTENSION);
    }

    @Override
    public Map<String, String> loadPrimaryMessages(String filePath) {
        return Optional.ofNullable(TsMessageLoader.loadFile(filePath)).map(TypeScriptBabylonParserListener::getPropertyDefinitions).orElse(Collections.emptyMap());
    }

    @Override
    public Map<String, Map<String, String>> loadTranslations(String filePath, List<String> languages) {
        return languages.stream().map(lang -> new AbstractMap.SimpleEntry<String, Map<String, String>>((String)lang, this.loadTranslations(filePath, (String)lang))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    public static Map<String, String> dumpTsFile(Reader reader) throws IOException {
        return TsMessageLoader.readTsFile(reader).getPropertyDefinitions();
    }

    public static TypeScriptBabylonParserListener readTsFile(Reader reader) throws IOException {
        CodePointCharStream input = CharStreams.fromReader((Reader)reader);
        TypeScriptLexer lexer = new TypeScriptLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        TypeScriptParser parser = new TypeScriptParser((TokenStream)tokens);
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object o, int i, int i1, String s, RecognitionException e) {
                log.error("Cannot parse: " + s + " at line " + i + " with exception: " + e.getMessage());
            }
        });
        TypeScriptParser.ProgramContext tree = parser.program();
        TypeScriptBabylonParserListener listener = new TypeScriptBabylonParserListener();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)listener, (ParseTree)tree);
        return listener;
    }

    private Map<String, String> loadTranslations(String filePath, String language) {
        String translationFilePath = TranslationFileUtils.getFileNameForTranslation(filePath, language);
        return Optional.ofNullable(TsMessageLoader.loadFile(translationFilePath)).map(TypeScriptBabylonParserListener::getPropertyDefinitions).orElse(Collections.emptyMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TypeScriptBabylonParserListener loadFile(String filePath) {
        if (!FileUtils.exists(filePath)) return null;
        log.info("Processing ts file: " + filePath);
        try (FileReader inputStreamReader = new FileReader(TsMessageLoader.fileFromPath(filePath));){
            TypeScriptBabylonParserListener typeScriptBabylonParserListener = TsMessageLoader.readTsFile(inputStreamReader);
            return typeScriptBabylonParserListener;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static File fileFromPath(String path) {
        return FileUtils.fileFromPathOrThrow(path);
    }
}

