/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.db;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import one.edee.babylon.db.SnapshotUtils;
import one.edee.babylon.snapshot.Snapshot;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SnapshotManager {
    private static final Log log = LogFactory.getLog(SnapshotManager.class);
    private Path snapshotFile;
    private Snapshot snapshot;
    private Snapshot originalSnapshotOnDisk;

    public SnapshotManager(Path snapshotFile) throws IOException {
        this.snapshotFile = snapshotFile;
        this.loadOriginalDataFile();
    }

    @Deprecated
    protected void forceSetSnapshotFile(Path snapshotFile) throws IOException {
        this.snapshotFile = snapshotFile;
        this.loadOriginalDataFile();
        this.snapshot = this.getExistingDataFileFromDisk(snapshotFile);
    }

    private void loadOriginalDataFile() throws IOException {
        this.originalSnapshotOnDisk = this.getExistingDataFileFromDisk(this.snapshotFile);
        if (this.originalSnapshotOnDisk == null) {
            this.originalSnapshotOnDisk = new Snapshot();
        }
    }

    @Deprecated
    public Snapshot getOriginalDataFile() {
        return this.originalSnapshotOnDisk;
    }

    public Snapshot getOrCreateDataFile() throws IOException {
        if (this.snapshot == null) {
            this.snapshot = this.getExistingDataFileFromDisk(this.snapshotFile);
            if (this.snapshot == null) {
                this.snapshot = new Snapshot();
            }
        }
        return this.snapshot;
    }

    private Snapshot getExistingDataFileFromDisk(Path snapshotFile) throws IOException {
        File file = snapshotFile.toFile();
        if (file.exists() && file.length() != 0L) {
            Snapshot df = SnapshotUtils.readSnapshot((File)file);
            this.loadDataPropFilesIds(df);
            return df;
        }
        return null;
    }

    private void loadDataPropFilesIds(Snapshot df) {
        df.getProps().forEach((key, value) -> {
            if (value.getId() != null) {
                df.putDataPropFileById(value.getId(), value);
            } else {
                log.warn((Object)("Id for path \"" + key + "\" not found."));
            }
        });
    }
}

