/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon;

import java.util.Arrays;
import java.util.stream.Collectors;
import one.edee.babylon.MainService;
import one.edee.babylon.SpringBootConsoleApplication;
import one.edee.babylon.config.TranslationConfiguration;
import one.edee.babylon.config.TranslationConfigurationReader;
import one.edee.babylon.enums.Action;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
public class SpringBootConsoleApplication
implements CommandLineRunner {
    private static final Log log = LogFactory.getLog(SpringBootConsoleApplication.class);
    @Autowired
    private MainService mainService;
    private final TranslationConfigurationReader configurationReader = new TranslationConfigurationReader();

    public static void main(String[] args) {
        SpringApplication.run(SpringBootConsoleApplication.class, (String[])args);
    }

    public void run(String ... args) {
        log.info((Object)("STARTING THE BABYLON FROM DIRECTORY: " + System.getProperty("user.dir")));
        log.info((Object)"WITH ARGUMENTS: ");
        for (int i = 0; i < args.length; ++i) {
            log.info((Object)String.format("args[%d]: %s", i, args[i]));
        }
        Arguments arguments = SpringBootConsoleApplication.parseArguments((String[])args);
        try {
            log.info((Object)("Loading config file: '" + arguments.getConfigFileName() + "'"));
            TranslationConfiguration configuration = this.configurationReader.readAndCheckConfiguration(arguments.getConfigFileName());
            this.mainService.startTranslation(arguments.getAction(), configuration, arguments.getGoogleSheetId(), arguments.isCombineSheets());
        }
        catch (Exception e) {
            log.error((Object)"BABYLON ERROR: ", (Throwable)e);
            System.exit(-1);
        }
    }

    public static Arguments parseArguments(String ... args) {
        if (args.length != 2 && args.length != 3 && args.length != 4 && args.length != 5) {
            log.error((Object)"Invalid input arguments, required: ");
            SpringBootConsoleApplication.printRequiredArguments();
            System.exit(-1);
        }
        Arguments arguments = new Arguments();
        try {
            arguments.setAction(Action.valueOf((String)args[0].toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            String validActions = Arrays.stream(Action.values()).map(action -> "\"" + action.name() + "\"").collect(Collectors.joining(" or "));
            String msg = String.format("Unexpected value of first argument: \"%s\". Valid values is %s", args[0], validActions);
            throw new IllegalArgumentException(msg);
        }
        arguments.setConfigFileName(args[1]);
        if (args.length > 2) {
            arguments.setGoogleSheetId(args[2]);
        }
        if (args.length > 3) {
            arguments.setCombineSheets(Boolean.parseBoolean(args[3]));
        }
        return arguments;
    }

    private static void printRequiredArguments() {
        log.info((Object)"1 - expected action (import, export)");
        log.info((Object)"2 - path to translator-config.json file");
        log.info((Object)"3 - ID of the google sheet (e.g. 1xhnBAOpy8-9KWhl8NP0ZIy6mhlgXKnKcLJwKcIeyjPc)");
        log.info((Object)"4 - arg to specify combineSheets mode");
    }
}

