/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.export.translator;

import com.google.cloud.translate.Translate;
import com.google.cloud.translate.TranslateOptions;
import com.google.cloud.translate.Translation;
import java.util.List;
import java.util.stream.Collectors;
import one.edee.babylon.config.SupportedTranslators;
import one.edee.babylon.export.translator.Translator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class GoogleTranslator
implements Translator {
    Translate service = null;

    public void init(@NotNull String apiKey) {
        this.service = (Translate)TranslateOptions.newBuilder().setApiKey(apiKey).build().getService();
    }

    public List<String> translate(@Nullable String defaultLang, @NotNull List<String> original, @NotNull String lang) {
        Assert.notNull((Object)this.service, (String)"Init method with api key has to be called before translation!");
        return this.service.translate(original, new Translate.TranslateOption[]{Translate.TranslateOption.sourceLanguage((String)defaultLang), Translate.TranslateOption.targetLanguage((String)lang)}).stream().map(Translation::getTranslatedText).collect(Collectors.toList());
    }

    public SupportedTranslators getSupportedTranslator() {
        return SupportedTranslators.GOOGLE;
    }
}

