/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.sheets.gsheets.legacy;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.extensions.jetty.auth.oauth2.LocalServerReceiver;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.client.util.store.FileDataStoreFactory;
import com.google.api.services.sheets.v4.Sheets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import one.edee.babylon.sheets.gsheets.GSheetsClient;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.NonNull;

public class AuthorizedGSheetsClient
implements GSheetsClient {
    private static final Log log = LogFactory.getLog(AuthorizedGSheetsClient.class);
    private static final String APPLICATION_NAME = "Google Sheets API for Babylon";
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private static final List<String> SCOPES = Collections.singletonList("https://www.googleapis.com/auth/spreadsheets");
    private static final String TOKENS_DIRECTORY_PATH = "tokens";
    private static final String GOOGLE_CREDENTIALS_JSON = "credentials.json";
    private static final int TIMEOUT_MS = 60000;
    private Credential credential;
    private Sheets sheetService;

    @NonNull
    public Sheets getSheetService() throws GeneralSecurityException, IOException {
        if (this.sheetService == null) {
            NetHttpTransport HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            this.sheetService = new Sheets.Builder((HttpTransport)HTTP_TRANSPORT, JSON_FACTORY, this.createHttpRequestInitializer((HttpRequestInitializer)this.getCredentials(HTTP_TRANSPORT))).setApplicationName(APPLICATION_NAME).build();
        }
        return this.sheetService;
    }

    private HttpRequestInitializer createHttpRequestInitializer(HttpRequestInitializer requestInitializer) {
        return httpRequest -> {
            requestInitializer.initialize(httpRequest);
            httpRequest.setConnectTimeout(180000);
            httpRequest.setReadTimeout(180000);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private Credential getCredentials(NetHttpTransport httpTransport) throws IOException {
        if (this.credential == null) {
            File credentialsFile = new File(GOOGLE_CREDENTIALS_JSON);
            InputStream credentialsStream = null;
            InputStreamReader credentialsReader = null;
            try {
                credentialsStream = credentialsFile.exists() ? Files.newInputStream(credentialsFile.toPath(), new OpenOption[0]) : this.getClass().getClassLoader().getResourceAsStream(GOOGLE_CREDENTIALS_JSON);
                assert (credentialsStream != null);
                credentialsReader = new InputStreamReader(credentialsStream);
                GoogleClientSecrets clientSecrets = GoogleClientSecrets.load((JsonFactory)JSON_FACTORY, (Reader)credentialsReader);
                GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder((HttpTransport)httpTransport, JSON_FACTORY, clientSecrets, (Collection)SCOPES).setDataStoreFactory((DataStoreFactory)new FileDataStoreFactory(new File(TOKENS_DIRECTORY_PATH))).setAccessType("offline").build();
                LocalServerReceiver.Builder builder = new LocalServerReceiver.Builder();
                if (SystemUtils.IS_OS_MAC) {
                    builder.setHost("127.0.0.1");
                }
                LocalServerReceiver receiver = builder.setPort(8888).build();
                this.credential = new AuthorizationCodeInstalledApp((AuthorizationCodeFlow)flow, (VerificationCodeReceiver)receiver).authorize("user");
            }
            finally {
                if (credentialsStream != null) {
                    credentialsStream.close();
                }
                if (credentialsReader != null) {
                    credentialsReader.close();
                }
            }
        }
        return this.credential;
    }
}

