/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.properties;

import com.google.common.io.LineReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import one.edee.babylon.enums.PropertyType;
import one.edee.babylon.properties.AbstractProperty;
import one.edee.babylon.properties.FileActiveRecord;
import one.edee.babylon.properties.Property;

public class PropertyFileActiveRecord
extends FileActiveRecord {
    @Override
    public void load(Reader reader) throws IOException {
        this.loadByLineReader(new LineReader((Readable)reader));
    }

    @Override
    public void save(Writer writer, String baseFileName, String mutation) throws IOException {
        this.saveByBufferedWriter(writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadByLineReader(LineReader lr) throws IOException {
        PropertyFileActiveRecord propertyFileActiveRecord = this;
        synchronized (propertyFileActiveRecord) {
            String line;
            int row = 1;
            while ((line = lr.readLine()) != null) {
                Map.Entry<String, Property> entry = this.parseProperty(line, row, lr);
                this.put(entry.getKey(), entry.getValue());
                if (entry.getValue().isPropValueMultiLine()) {
                    row += entry.getValue().getRowCount().intValue();
                    continue;
                }
                ++row;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveByBufferedWriter(BufferedWriter bw) throws IOException {
        PropertyFileActiveRecord propertyFileActiveRecord = this;
        synchronized (propertyFileActiveRecord) {
            Iterator iterator = this.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry e = iterator.next();
                String key = (String)e.getKey();
                AbstractProperty value = (AbstractProperty)e.getValue();
                if (value.isPropValue() || value.isPropValueMultiLine()) {
                    bw.write(key + "=" + ((AbstractProperty)e.getValue()).getQuotedValue());
                    if (iterator.hasNext()) {
                        bw.newLine();
                    }
                }
                if (value.isPropEmptyLine()) {
                    bw.newLine();
                    continue;
                }
                if (!value.isPropComment()) continue;
                bw.write(((AbstractProperty)e.getValue()).getQuotedValue());
                if (!iterator.hasNext()) continue;
                bw.newLine();
            }
        }
        bw.flush();
    }

    private Map.Entry<String, Property> parseProperty(String line, int row, LineReader lr) throws IOException {
        if ((line = line.trim()).contains("=")) {
            String[] keyAndVal = line.split("=", 2);
            return this.createPropValueEntry(keyAndVal, lr);
        }
        if (line.isEmpty()) {
            Property propEmptyLine = new Property(PropertyType.EMPTY, "");
            return new AbstractMap.SimpleEntry<String, Property>("" + row, propEmptyLine);
        }
        if (line.startsWith("#") || line.startsWith("!")) {
            Property propComment = new Property(PropertyType.COMMENT, line);
            return new AbstractMap.SimpleEntry<String, Property>("" + row, propComment);
        }
        Property propUnknown = new Property(PropertyType.UNKNOWN, line);
        return new AbstractMap.SimpleEntry<String, Property>("" + row, propUnknown);
    }

    private Map.Entry<String, Property> createPropValueEntry(String[] keyAndVal, LineReader lr) throws IOException {
        Property propValue;
        String value;
        String key = keyAndVal[0].trim();
        String string = value = keyAndVal.length > 1 ? keyAndVal[1].trim() : "";
        if (!value.endsWith("\\")) {
            propValue = new Property(PropertyType.VALUE, value);
        } else {
            String line;
            Property multiLine = new Property(PropertyType.MULTILINE, value);
            multiLine.addLine(value);
            do {
                if ((line = lr.readLine()).trim().isEmpty()) continue;
                multiLine.addLine(line);
            } while (line.endsWith("\\") && !line.trim().isEmpty());
            propValue = multiLine;
        }
        return new AbstractMap.SimpleEntry<String, Property>(key, propValue);
    }
}

