/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.properties;

import java.util.LinkedList;
import java.util.List;
import one.edee.babylon.enums.PropertyType;
import one.edee.babylon.properties.AbstractProperty;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class Property
extends AbstractProperty {
    static final String MULTILINE_SEPARATOR = "\\";
    private String value;
    private final List<String> lines = new LinkedList();

    public Property(PropertyType type, String value) {
        super(type);
        this.value = Property.clearValue((String)value);
    }

    void addLine(String line) {
        this.lines.add(line.replace(System.lineSeparator(), "").replace("\r\n", ""));
    }

    public Integer getRowCount() {
        return this.lines.size();
    }

    public String getQuotedValue() {
        return super.getQuotedValue().replace("\r\n", System.lineSeparator());
    }

    public String getValue() {
        if (this.isPropValueMultiLine()) {
            return this.getMultilineValue();
        }
        if (this.isPropEmptyLine()) {
            return "";
        }
        return this.value;
    }

    public void setValue(String value) {
        value = Property.clearValue((String)value);
        if (this.isPropValueMultiLine()) {
            this.setMultilineValue(value);
            return;
        }
        this.value = value;
    }

    private void setMultilineValue(String value) {
        if (StringUtils.isEmpty((Object)value)) {
            this.lines.clear();
            return;
        }
        String[] split = value.split("\\\\\r\n");
        this.lines.clear();
        for (int i = 0; i < split.length; ++i) {
            String line = split[i];
            if (i < split.length - 1 && !line.endsWith("\\")) {
                line = line + "\\";
            }
            this.lines.add(line);
        }
    }

    private String getMultilineValue() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = (String)this.lines.get(i);
            sb.append(line);
            if (i >= this.lines.size() - 1 || line.endsWith(System.lineSeparator())) continue;
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static String clearValue(String value) {
        return value.replace("\n", "\\n");
    }
}

